/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.harvesting;

import java.util.function.Predicate;
import me.desht.pneumaticcraft.common.harvesting.HarvestHandlerAbstractCrop;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class HarvestHandlerCropLike
extends HarvestHandlerAbstractCrop {
    private final IntegerProperty ageProperty;
    private final int minAge;
    private final int maxAge;
    private final Predicate<ItemStack> isSeed;

    public HarvestHandlerCropLike(Predicate<BlockState> blockChecker, IntegerProperty ageProperty, Predicate<ItemStack> isSeed) {
        super(blockChecker);
        this.ageProperty = ageProperty;
        this.isSeed = isSeed;
        this.minAge = ageProperty.getPossibleValues().stream().mapToInt(Integer::intValue).min().orElse(0);
        this.maxAge = ageProperty.getPossibleValues().stream().mapToInt(Integer::intValue).max().orElse(7);
    }

    @Override
    protected boolean isSeed(Level world, BlockPos pos, BlockState state, ItemStack stack) {
        return this.isSeed.test(stack);
    }

    @Override
    protected boolean isMaxAge(BlockState state) {
        return (Integer)state.getValue((Property)this.ageProperty) == this.maxAge;
    }

    @Override
    protected BlockState withMinAge(BlockState state) {
        return (BlockState)state.setValue((Property)this.ageProperty, (Comparable)Integer.valueOf(this.minAge));
    }

    public static class SweetBerry
    extends HarvestHandlerCropLike {
        public SweetBerry() {
            super(state -> state.getBlock() == Blocks.SWEET_BERRY_BUSH, SweetBerryBushBlock.AGE, stack -> stack.getItem() == Items.SWEET_BERRIES);
        }

        @Override
        protected BlockState withMinAge(BlockState state) {
            return (BlockState)state.setValue((Property)SweetBerryBushBlock.AGE, (Comparable)Integer.valueOf(1));
        }
    }

    public static class NetherWart
    extends HarvestHandlerCropLike {
        public NetherWart() {
            super(state -> state.getBlock() == Blocks.NETHER_WART, NetherWartBlock.AGE, stack -> stack.getItem() == Items.NETHER_WART);
        }
    }

    public static class Cocoa
    extends HarvestHandlerCropLike {
        public Cocoa() {
            super(state -> state.getBlock() == Blocks.COCOA, CocoaBlock.AGE, stack -> stack.getItem() == Items.COCOA_BEANS);
        }
    }
}

