/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.client.IFOVModifierItem;
import me.desht.pneumaticcraft.api.data.PneumaticCraftTags;
import me.desht.pneumaticcraft.api.item.ICustomDurabilityBar;
import me.desht.pneumaticcraft.api.pressure.IPressurizableItem;
import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.entity.drone.ProgrammableControllerBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.utility.ChargingStationBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.entity.drone.AbstractDroneEntity;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.entity.drone.ProgrammableControllerEntity;
import me.desht.pneumaticcraft.common.item.IChargeableContainerProvider;
import me.desht.pneumaticcraft.common.item.PressurizableItem;
import me.desht.pneumaticcraft.common.network.DronePacket;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.ElytraHandler;
import me.desht.pneumaticcraft.common.registry.ModArmorMaterials;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModMenuTypes;
import me.desht.pneumaticcraft.common.thirdparty.theoneprobe.TheOneProbe;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.upgrades.UpgradableItemUtils;
import me.desht.pneumaticcraft.common.util.GlobalPosHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class PneumaticArmorItem
extends ArmorItem
implements IChargeableContainerProvider,
IFOVModifierItem,
ICustomDurabilityBar,
IPressurizableItem,
ColorHandlers.ITintableItem {
    private static final Map<EquipmentSlotGroup, ResourceLocation> MODIFIER_IDS = (Map)Util.make(new EnumMap(EquipmentSlotGroup.class), map -> {
        map.put(EquipmentSlotGroup.HEAD, PneumaticRegistry.RL("armor_mod_head"));
        map.put(EquipmentSlotGroup.CHEST, PneumaticRegistry.RL("armor_mod_chest"));
        map.put(EquipmentSlotGroup.LEGS, PneumaticRegistry.RL("armor_mod_legs"));
        map.put(EquipmentSlotGroup.FEET, PneumaticRegistry.RL("armor_mod_feet"));
    });
    private static final int[] ARMOR_VOLUMES = new int[]{12000, 12000, 28000, 12000};
    public static final DyedItemColor DEFAULT_PRIMARY_COLOR = new DyedItemColor(-6908266, false);
    public static final DyedItemColor DEFAULT_SECONDARY_COLOR = new DyedItemColor(-4144960, false);
    public static final DyedItemColor DEFAULT_EYEPIECE_COLOR = new DyedItemColor(-16733696, false);

    public PneumaticArmorItem(ArmorItem.Type type) {
        super(ModArmorMaterials.PNEUMATIC.getDelegate(), type, ModItems.pressurizableToolProps().durability(type.getDurability(24)));
    }

    public static boolean isPlayerWearingAnyPneumaticArmor(Player player) {
        for (EquipmentSlot slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            if (!PneumaticArmorItem.isPneumaticArmorPiece(player, slot)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPneumaticArmorPiece(Player player, EquipmentSlot slot) {
        return player.getItemBySlot(slot).getItem() instanceof PneumaticArmorItem;
    }

    @Override
    public int getBaseVolume() {
        return ARMOR_VOLUMES[this.type.getSlot().getIndex()];
    }

    @Override
    public int getVolumeUpgrades(ItemStack stack) {
        return UpgradableItemUtils.getUpgradeCount(stack, ModUpgrades.VOLUME.get());
    }

    @Override
    public int getAir(ItemStack stack) {
        return (Integer)stack.getOrDefault(ModDataComponents.AIR, (Object)0);
    }

    @Override
    public float getMaxPressure() {
        return 10.0f;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        if (this.type == ArmorItem.Type.HELMET && context.registries() != null) {
            ClientUtils.getOptionalClientLevel().ifPresent(level -> this.addHelmetInformation(stack, (Level)level, tooltip));
        }
    }

    private void addHelmetInformation(ItemStack stack, Level level, List<Component> tooltip) {
        BlockPos pos;
        ItemStack searchStack;
        Item searchedItem;
        if (TheOneProbe.isProbeEnabled(stack)) {
            tooltip.add((Component)PneumaticCraftUtils.xlate("gui.tooltip.item.pneumaticcraft.pneumatic_helmet.one_probe", new Object[0]).withStyle(ChatFormatting.BLUE));
        }
        if ((searchedItem = PneumaticArmorItem.getSearchedItem(stack)) != null && !(searchStack = new ItemStack((ItemLike)searchedItem)).isEmpty()) {
            tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.upgrade.search", new Object[0]).append(": ").append(searchStack.getHoverName()).withStyle(ChatFormatting.YELLOW));
        }
        if ((pos = PneumaticArmorItem.getCoordTrackerPos(stack, level)) != null) {
            tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.upgrade.coordinate_tracker", new Object[0]).append(": ").append(PneumaticCraftUtils.posToString(pos)).withStyle(ChatFormatting.YELLOW));
        }
    }

    public boolean isFoil(ItemStack stack) {
        return (Boolean)ConfigHelper.client().armor.showEnchantGlint.get() != false && super.isFoil(stack);
    }

    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return this.type.getSlot();
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        EquipmentSlotGroup group;
        int upgrades;
        ItemAttributeModifiers modifiers = super.getDefaultAttributeModifiers(stack);
        if (stack.getEquipmentSlot() == this.type.getSlot() && (upgrades = UpgradableItemUtils.getUpgradeCount(stack, ModUpgrades.ARMOR.get())) > 0 && MODIFIER_IDS.containsKey(group = EquipmentSlotGroup.bySlot((EquipmentSlot)this.type.getSlot()))) {
            AttributeModifier armor = new AttributeModifier(MODIFIER_IDS.get(group), (double)upgrades / 2.0, AttributeModifier.Operation.ADD_VALUE);
            AttributeModifier armorToughness = new AttributeModifier(MODIFIER_IDS.get(group), (double)upgrades, AttributeModifier.Operation.ADD_VALUE);
            return modifiers.withModifierAdded(Attributes.ARMOR, armor, group).withModifierAdded(Attributes.ARMOR_TOUGHNESS, armorToughness, group);
        }
        return modifiers;
    }

    public static int getIntData(ItemStack stack, DataComponentType<Integer> componentType, int def) {
        return (Integer)stack.getOrDefault(componentType, (Object)def);
    }

    public static int getIntData(ItemStack stack, DataComponentType<Integer> componentType, int def, int min, int max) {
        return Mth.clamp((int)((Integer)stack.getOrDefault(componentType, (Object)def)), (int)min, (int)max);
    }

    public static boolean getBooleanData(ItemStack stack, DataComponentType<Boolean> componentType, boolean def) {
        return (Boolean)stack.getOrDefault(componentType, (Object)def);
    }

    public static Item getSearchedItem(ItemStack helmetStack) {
        return helmetStack.has(ModDataComponents.HELMET_SEARCH_ITEM) ? (Item)helmetStack.get(ModDataComponents.HELMET_SEARCH_ITEM) : null;
    }

    public static void setSearchedItem(ItemStack helmetStack, Item searchedItem) {
        if (helmetStack.getItem() instanceof PneumaticArmorItem) {
            helmetStack.set(ModDataComponents.HELMET_SEARCH_ITEM, (Object)searchedItem);
        }
    }

    public static BlockPos getCoordTrackerPos(ItemStack helmetStack, Level world) {
        GlobalPos gPos;
        if (helmetStack.has(ModDataComponents.COORD_TRACKER) && !world.isOutsideBuildHeight((gPos = (GlobalPos)helmetStack.get(ModDataComponents.COORD_TRACKER)).pos().getY()) && GlobalPosHelper.isSameWorld(gPos, world)) {
            return ((GlobalPos)helmetStack.get(ModDataComponents.COORD_TRACKER)).pos();
        }
        return null;
    }

    public static void setCoordTrackerPos(ItemStack helmetStack, GlobalPos gPos) {
        helmetStack.set(ModDataComponents.COORD_TRACKER, (Object)gPos);
    }

    public static String getEntityFilter(ItemStack helmetStack) {
        return (String)helmetStack.getOrDefault(ModDataComponents.ENTITY_FILTER, (Object)"");
    }

    public static boolean isPlayerDebuggingDrone(Player player, AbstractDroneEntity drone) {
        ItemStack helmet = player.getItemBySlot(EquipmentSlot.HEAD);
        if (helmet.getItem() != ModItems.PNEUMATIC_HELMET.get()) {
            return false;
        }
        if (drone instanceof DroneEntity) {
            return ((DronePacket.DroneTarget)helmet.getOrDefault(ModDataComponents.DRONE_DEBUG_TARGET, (Object)DronePacket.DroneTarget.NONE)).is((Entity)drone);
        }
        if (drone instanceof ProgrammableControllerEntity) {
            ProgrammableControllerEntity pc = (ProgrammableControllerEntity)drone;
            return ((DronePacket.DroneTarget)helmet.getOrDefault(ModDataComponents.DRONE_DEBUG_TARGET, (Object)DronePacket.DroneTarget.NONE)).is(pc.getControllerPos());
        }
        return false;
    }

    public static boolean isPlayerDebuggingDrone(Player player, IDroneBase drone) {
        ItemStack helmet = player.getItemBySlot(EquipmentSlot.HEAD);
        if (helmet.getItem() != ModItems.PNEUMATIC_HELMET.get()) {
            return false;
        }
        if (drone instanceof DroneEntity) {
            DroneEntity e = (DroneEntity)drone;
            return ((DronePacket.DroneTarget)helmet.getOrDefault(ModDataComponents.DRONE_DEBUG_TARGET, (Object)DronePacket.DroneTarget.NONE)).is((Entity)e);
        }
        if (drone instanceof ProgrammableControllerBlockEntity) {
            ProgrammableControllerBlockEntity pc = (ProgrammableControllerBlockEntity)drone;
            return ((DronePacket.DroneTarget)helmet.getOrDefault(ModDataComponents.DRONE_DEBUG_TARGET, (Object)DronePacket.DroneTarget.NONE)).is(pc.getControllerPos());
        }
        return false;
    }

    public static IDroneBase getDebuggedDrone(Player player) {
        ItemStack helmet = player.getItemBySlot(EquipmentSlot.HEAD);
        if (helmet.getItem() == ModItems.PNEUMATIC_HELMET.get() && helmet.has(ModDataComponents.DRONE_DEBUG_TARGET)) {
            return ((DronePacket.DroneTarget)helmet.getOrDefault(ModDataComponents.DRONE_DEBUG_TARGET, (Object)DronePacket.DroneTarget.NONE)).getDrone(player.level());
        }
        return null;
    }

    @Override
    public float getFOVModifier(ItemStack stack, Player player, EquipmentSlot slot) {
        double boost;
        if (slot == EquipmentSlot.LEGS && (Double)ConfigHelper.client().armor.leggingsFOVFactor.get() > 0.0 && (boost = CommonUpgradeHandlers.runSpeedHandler.getSpeedBoostFromLegs(CommonArmorHandler.getHandlerForPlayer())) > 0.0) {
            return 1.0f + (float)(boost * 2.0 * (Double)ConfigHelper.client().armor.leggingsFOVFactor.get());
        }
        return 1.0f;
    }

    @Override
    public MenuProvider getContainerProvider(ChargingStationBlockEntity te) {
        return new IChargeableContainerProvider.Provider(te, ModMenuTypes.CHARGING_ARMOR.get());
    }

    @Override
    public boolean shouldShowCustomDurabilityBar(ItemStack stack) {
        return PressurizableItem.shouldShowPressureDurability(stack);
    }

    @Override
    public int getCustomDurabilityColour(ItemStack stack) {
        return PressurizableItem.getPressureDurabilityColor(stack);
    }

    @Override
    public float getCustomDurability(ItemStack stack) {
        return PNCCapabilities.getAirHandler(stack).map(h -> Float.valueOf(h.getPressure() / h.maxPressure())).orElseThrow(RuntimeException::new).floatValue();
    }

    @Override
    public int getTintColor(ItemStack stack, int tintIndex) {
        return switch (tintIndex) {
            case 0 -> this.getPrimaryColor(stack);
            case 1 -> this.getSecondaryColor(stack);
            case 2 -> {
                if (stack.getItem() == ModItems.PNEUMATIC_HELMET.get()) {
                    yield this.getEyepieceColor(stack);
                }
                yield -1;
            }
            default -> -1;
        };
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        if (wearer instanceof Player) {
            Player player = (Player)wearer;
            Item item = stack.getItem();
            if (item instanceof PneumaticArmorItem) {
                PneumaticArmorItem armor = (PneumaticArmorItem)item;
                return CommonArmorHandler.getHandlerForPlayer(player).getUpgradeCount(armor.type.getSlot(), ModUpgrades.GILDED.get()) > 0;
            }
        }
        return false;
    }

    public boolean isEnderMask(ItemStack stack, Player player, EnderMan endermanEntity) {
        CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(player);
        return handler.upgradeUsable(CommonUpgradeHandlers.enderVisorHandler, true);
    }

    public boolean canWalkOnPowderedSnow(ItemStack stack, LivingEntity wearer) {
        if (wearer instanceof Player) {
            Player player = (Player)wearer;
            return CommonArmorHandler.getHandlerForPlayer(player).getUpgradeCount(EquipmentSlot.FEET, ModUpgrades.FLIPPERS.get()) > 0;
        }
        return false;
    }

    public boolean isDamageable(ItemStack stack) {
        return UpgradableItemUtils.getUpgradeCount(stack, ModUpgrades.CREATIVE.get()) == 0;
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        Player player;
        if (entity instanceof Player && CommonArmorHandler.getHandlerForPlayer(player = (Player)entity).upgradeUsable(CommonUpgradeHandlers.elytraHandler, true)) {
            return true;
        }
        return super.canElytraFly(stack, entity);
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        return ElytraHandler.handleFlightTick(entity, flightTicks) || super.elytraFlightTick(stack, entity, flightTicks);
    }

    public int getPrimaryColor(ItemStack stack) {
        return ((DyedItemColor)stack.getOrDefault(DataComponents.DYED_COLOR, (Object)DEFAULT_PRIMARY_COLOR)).rgb();
    }

    public void setPrimaryColor(ItemStack stack, int color) {
        stack.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(color, false));
    }

    public int getSecondaryColor(ItemStack stack) {
        return ((DyedItemColor)stack.getOrDefault(ModDataComponents.ARMOR_SECONDARY_COLOR, (Object)DEFAULT_SECONDARY_COLOR)).rgb();
    }

    public void setSecondaryColor(ItemStack stack, int color) {
        stack.set(ModDataComponents.ARMOR_SECONDARY_COLOR, (Object)new DyedItemColor(color, false));
    }

    public int getEyepieceColor(ItemStack stack) {
        return ((DyedItemColor)stack.getOrDefault(ModDataComponents.ARMOR_EYEPIECE_COLOR, (Object)DEFAULT_EYEPIECE_COLOR)).rgb();
    }

    public void setEyepieceColor(ItemStack stack, int color) {
        stack.set(ModDataComponents.ARMOR_EYEPIECE_COLOR, (Object)new DyedItemColor(color, false));
    }

    @Override
    public Optional<TagKey<Item>> getUpgradeBlacklistTag() {
        return Optional.of(PneumaticCraftTags.Items.ARMOR_UPGRADE_BLACKLIST);
    }
}

