/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.client.gui.ProgrammerScreen;
import me.desht.pneumaticcraft.common.block.entity.drone.ProgrammerBlockEntity;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.inventory.ProgrammerMenu;
import me.desht.pneumaticcraft.common.network.PacketUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketProgrammerSync(BlockPos pos, List<IProgWidget> widgets) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketProgrammerSync> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("programmer_sync"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketProgrammerSync> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PacketProgrammerSync::pos, (StreamCodec)ProgWidget.STREAM_CODEC.apply(ByteBufCodecs.list()), PacketProgrammerSync::widgets, PacketProgrammerSync::new);

    public static PacketProgrammerSync forBlockEntity(ProgrammerBlockEntity te) {
        return new PacketProgrammerSync(te.getBlockPos(), te.progWidgets);
    }

    public CustomPacketPayload.Type<PacketProgrammerSync> type() {
        return TYPE;
    }

    public static void handle(PacketProgrammerSync message, IPayloadContext ctx) {
        if (ctx.player().isLocalPlayer() || ctx.player().containerMenu instanceof ProgrammerMenu) {
            PacketUtil.getBlockEntity(ctx.player(), message.pos, ProgrammerBlockEntity.class).ifPresent(te -> te.setProgWidgets(message.widgets, ctx.player()));
            if (ctx.player().level().isClientSide()) {
                ProgrammerScreen.updateProgramNameIfOpen();
            }
        }
    }
}

