/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util.entityfilter;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import joptsimple.internal.Strings;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.IEntityProvider;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetText;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.entityfilter.FilterModifier;
import me.desht.pneumaticcraft.common.util.entityfilter.FilterModifiers;
import net.minecraft.Util;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.DyeColor;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class EntityFilter
implements Predicate<Entity> {
    private static final Pattern ELEMENT_DIVIDER = Pattern.compile(";");
    private static final Pattern ELEMENT_SUBDIVIDER = Pattern.compile("[(),]");
    private static final Map<String, Predicate<Entity>> ENTITY_PREDICATES = ImmutableMap.builder().put((Object)"mob", e -> {
        TamableAnimal t;
        return e instanceof Enemy && (!(e instanceof TamableAnimal) || !(t = (TamableAnimal)e).isTame());
    }).put((Object)"animal", e -> e instanceof Animal).put((Object)"living", e -> e instanceof LivingEntity).put((Object)"player", e -> {
        Player p;
        return e instanceof Player && !(p = (Player)e).isSpectator();
    }).put((Object)"item", e -> e instanceof ItemEntity).put((Object)"drone", e -> e instanceof DroneEntity).put((Object)"boat", e -> e instanceof Boat).put((Object)"minecart", e -> e instanceof AbstractMinecart).put((Object)"painting", e -> e instanceof Painting).put((Object)"orb", e -> e instanceof ExperienceOrb).put((Object)"nothing", e -> false).build();
    static final Set<String> DYE_COLORS = (Set)Util.make(new HashSet(), set -> {
        for (DyeColor d : DyeColor.values()) {
            set.add(d.getName());
        }
    });
    private final List<EntityMatcher> matchers = new ArrayList<EntityMatcher>();
    private final boolean sense;
    private final String rawFilter;

    public EntityFilter(String filter) {
        if (filter.startsWith("!")) {
            filter = filter.substring(1);
            this.sense = false;
        } else {
            this.sense = true;
        }
        this.rawFilter = filter;
        if (!filter.isEmpty()) {
            Arrays.stream(ELEMENT_DIVIDER.split(filter)).map(EntityMatcher::new).forEach(this.matchers::add);
        }
    }

    public static <T extends IEntityProvider & IProgWidget> EntityFilter fromProgWidget(T widget, boolean whitelist) {
        if (((IProgWidget)widget).getParameters().size() > 1) {
            int pos = widget.getEntityFilterPosition();
            IProgWidget w = ((IProgWidget)widget).getConnectedParameters()[whitelist ? pos : ((IProgWidget)widget).getParameters().size() + pos];
            if (w instanceof ProgWidgetText) {
                ArrayList<String> l = new ArrayList<String>();
                while (w instanceof ProgWidgetText) {
                    ProgWidgetText txt = (ProgWidgetText)w;
                    String str = txt.getString();
                    Validate.isTrue((!str.startsWith("!") ? 1 : 0) != 0, (String)"'!' negation can't be used here (put blacklist filters on left of widget)", (Object[])new Object[0]);
                    l.add(str);
                    w = w.getConnectedParameters()[0];
                }
                return new EntityFilter(Strings.join(l, (String)";"));
            }
        }
        return whitelist ? ConstantEntityFilter.ALLOW : ConstantEntityFilter.DENY;
    }

    public static EntityFilter fromString(String s) {
        return EntityFilter.fromString(s, null);
    }

    public static EntityFilter fromString(String s, EntityFilter fallback) {
        try {
            return new EntityFilter(s);
        }
        catch (Exception e) {
            return fallback;
        }
    }

    public static EntityFilter allow() {
        return ConstantEntityFilter.ALLOW;
    }

    public static EntityFilter deny() {
        return ConstantEntityFilter.DENY;
    }

    public String toString() {
        if (this == ConstantEntityFilter.ALLOW) {
            return "";
        }
        if (this == ConstantEntityFilter.DENY) {
            return "@nothing";
        }
        return this.sense ? this.rawFilter : "!" + this.rawFilter;
    }

    @Override
    public boolean test(Entity entity) {
        if (this.matchers.isEmpty()) {
            return true;
        }
        for (EntityMatcher m : this.matchers) {
            if (!m.test(entity)) continue;
            return this.sense;
        }
        return !this.sense;
    }

    public boolean isNone() {
        return this == EntityFilter.deny() || this.rawFilter.equals("@nothing");
    }

    private static String wildcardToRegex(String wildcard) {
        StringBuilder s = new StringBuilder(wildcard.length());
        s.append('^');
        int is = wildcard.length();
        block5: for (int i = 0; i < is; ++i) {
            char c = wildcard.charAt(i);
            switch (c) {
                case '*': {
                    s.append(".*");
                    continue block5;
                }
                case '?': {
                    s.append(".");
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    s.append("\\").append(c);
                    continue block5;
                }
                default: {
                    s.append(c);
                }
            }
        }
        s.append('$');
        return s.toString();
    }

    static {
        FilterModifiers.INSTANCE.registerDefaults();
    }

    public static class ConstantEntityFilter
    extends EntityFilter {
        static final ConstantEntityFilter ALLOW = new ConstantEntityFilter(true);
        static final ConstantEntityFilter DENY = new ConstantEntityFilter(false);
        private final boolean allow;

        private ConstantEntityFilter(boolean allow) {
            super("");
            this.allow = allow;
        }

        @Override
        public boolean test(Entity entity) {
            return this.allow;
        }
    }

    private static class EntityMatcher
    implements Predicate<Entity> {
        private final Predicate<Entity> matcher;
        private final List<ModifierEntry> modifiers = new ArrayList<ModifierEntry>();

        private EntityMatcher(String element) {
            List<String> splits = Arrays.stream(ELEMENT_SUBDIVIDER.split(element)).map(String::trim).toList();
            String arg0 = splits.getFirst();
            if (arg0.startsWith("@")) {
                String sub = arg0.substring(1);
                if (StringUtils.countMatches((CharSequence)element, (CharSequence)"(") != StringUtils.countMatches((CharSequence)element, (CharSequence)")")) {
                    throw new IllegalArgumentException("Mismatched opening/closing braces");
                }
                this.matcher = ENTITY_PREDICATES.get(sub);
                Validate.isTrue((this.matcher != null ? 1 : 0) != 0, (String)("Unknown entity type specifier: @" + sub), (Object[])new Object[0]);
            } else if (arg0.length() > 2 && (arg0.startsWith("\"") && arg0.endsWith("\"") || arg0.startsWith("'") && arg0.endsWith("'"))) {
                regex = Pattern.compile(EntityFilter.wildcardToRegex(arg0.substring(1, arg0.length() - 1)));
                this.matcher = e -> EntityMatcher.matchByName(e, regex);
            } else {
                regex = Pattern.compile(EntityFilter.wildcardToRegex(arg0), 2);
                this.matcher = e -> regex.matcher(PneumaticCraftUtils.getRegistryName(e).orElseThrow().getPath()).matches();
            }
            for (int i = 1; i < splits.size(); ++i) {
                String[] parts = splits.get(i).split("=");
                Validate.isTrue((parts.length == 2 ? 1 : 0) != 0, (String)("Invalid modifier syntax: " + splits.get(i)), (Object[])new Object[0]);
                String key = parts[0];
                String arg = parts[1];
                boolean sense = true;
                if (key.endsWith("!")) {
                    key = key.substring(0, key.length() - 1);
                    sense = false;
                }
                try {
                    FilterModifier modifier = FilterModifiers.INSTANCE.getModifier(key).orElseThrow(IllegalArgumentException::new);
                    if (!modifier.isValid(arg)) {
                        throw new IllegalArgumentException(String.format("Invalid value '%s' for modifier '%s'. Valid values: %s", arg, key, modifier.displayValidOptions()));
                    }
                    this.modifiers.add(new ModifierEntry(modifier, arg, sense));
                    continue;
                }
                catch (IllegalArgumentException e2) {
                    throw new IllegalArgumentException("Unknown modifier: " + key);
                }
            }
        }

        @Override
        public boolean test(Entity entity) {
            return this.matcher.test(entity) && this.modifiers.stream().allMatch(modifierEntry -> modifierEntry.test(entity));
        }

        private static boolean matchByName(Entity entity, Pattern regex) {
            Player player;
            return entity instanceof Player ? (player = (Player)entity).getGameProfile().getName() != null && regex.matcher(player.getGameProfile().getName()).matches() : entity.getCustomName() != null && regex.matcher(entity.getCustomName().getString()).matches();
        }
    }

    private record ModifierEntry(FilterModifier modifier, String value, boolean sense) implements Predicate<Entity>
    {
        @Override
        public boolean test(Entity e) {
            return this.modifier.test(e, this.value) == this.sense;
        }
    }
}

