/*
 * Decompiled with CFR 0.152.
 */
package thelm.packageddraconic.block;

import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import thelm.packagedauto.block.BaseBlock;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packageddraconic.block.entity.FusionCrafterBlockEntity;
import thelm.packageddraconic.block.entity.PackagedDraconicBlockEntities;

public class FusionCrafterBlock
extends BaseBlock {
    public static final VoxelShape SHAPE = FusionCrafterBlock.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);

    public FusionCrafterBlock() {
        super(BlockBehaviour.Properties.of().strength(10.0f, 15.0f).noOcclusion().mapColor(MapColor.METAL).sound(SoundType.METAL));
    }

    public FusionCrafterBlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return (FusionCrafterBlockEntity)((BlockEntityType)PackagedDraconicBlockEntities.FUSION_CRAFTER.get()).create(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return BaseBlockEntity::tick;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (player.isShiftKeyDown() && (blockEntity = level.getBlockEntity(pos)) instanceof FusionCrafterBlockEntity) {
            FusionCrafterBlockEntity crafter = (FusionCrafterBlockEntity)blockEntity;
            if (!crafter.isWorking) {
                Component message;
                if (!level.isClientSide && (message = crafter.getMessage()) != null) {
                    player.sendSystemMessage(message);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() == newState.getBlock()) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FusionCrafterBlockEntity) {
            FusionCrafterBlockEntity crafter = (FusionCrafterBlockEntity)blockEntity;
            if (crafter.isWorking) {
                crafter.cancelCraft();
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }
}

