/*
 * Decompiled with CFR 0.152.
 */
package thelm.packageddraconic.block.entity;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.api.crafting.IFusionInjector;
import com.brandon3055.draconicevolution.api.crafting.IFusionInventory;
import com.brandon3055.draconicevolution.api.crafting.IFusionRecipe;
import com.brandon3055.draconicevolution.api.crafting.IFusionStateMachine;
import com.google.common.collect.Streams;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.Runnables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import thelm.packagedauto.api.IPackageCraftingMachine;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.block.PackagedAutoBlocks;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.block.entity.PackagerBlockEntity;
import thelm.packagedauto.block.entity.PackagerExtensionBlockEntity;
import thelm.packagedauto.block.entity.PackagingProviderBlockEntity;
import thelm.packagedauto.block.entity.UnpackagerBlockEntity;
import thelm.packagedauto.energy.EnergyStorage;
import thelm.packagedauto.util.MiscHelper;
import thelm.packageddraconic.block.entity.MarkedInjectorBlockEntity;
import thelm.packageddraconic.block.entity.PackagedDraconicBlockEntities;
import thelm.packageddraconic.client.fx.FusionCrafterFXHandler;
import thelm.packageddraconic.inventory.FusionCrafterItemHandler;
import thelm.packageddraconic.menu.FusionCrafterMenu;
import thelm.packageddraconic.packet.FinishCraftEffectsPacket;
import thelm.packageddraconic.packet.SyncCrafterPacket;
import thelm.packageddraconic.recipe.IFusionPackageRecipeInfo;

public class FusionCrafterBlockEntity
extends BaseBlockEntity
implements IPackageCraftingMachine,
IFusionInventory,
IFusionStateMachine {
    public static int energyCapacity = 5000;
    public static int energyUsage = 5;
    public static boolean drawMEEnergy = true;
    public Runnable fxHandler = (Runnable)MiscHelper.INSTANCE.conditionalSupplier(() -> ((Dist)FMLEnvironment.dist).isClient(), () -> () -> new FusionCrafterFXHandler(this), () -> () -> Runnables.doNothing()).get();
    public RecipeHolder<IFusionRecipe> effectRecipe;
    public float animProgress = 0.0f;
    public short animLength = 0;
    public int[] requiredInjectors = new int[]{0, 0, 0, 0};
    public boolean isWorking = false;
    public IFusionStateMachine.FusionState fusionState = IFusionStateMachine.FusionState.START;
    public int fusionCounter = 0;
    public short progress = 0;
    public int minTier = -1;
    public IFusionPackageRecipeInfo currentRecipe;
    public List<BlockPos> injectors = new ArrayList<BlockPos>();

    public FusionCrafterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PackagedDraconicBlockEntities.FUSION_CRAFTER.get(), pos, state);
        this.setItemHandler(new FusionCrafterItemHandler(this));
        this.setEnergyStorage(new EnergyStorage((BaseBlockEntity)this, energyCapacity));
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"block.packageddraconic.fusion_crafter");
    }

    public Component getMessage() {
        if (this.isWorking) {
            return null;
        }
        MutableComponent message = Component.translatable((String)"block.packageddraconic.fusion_crafter.injectors.usable");
        MutableComponent usable = Component.literal((String)" ");
        for (int i2 = 0; i2 <= 3; ++i2) {
            int usableInjectors = this.getEmptyInjectorsForTier(i2).size();
            if (usableInjectors <= 0) continue;
            if (!usable.getSiblings().isEmpty()) {
                usable.append(", ");
            }
            usable.append((Component)Component.translatable((String)("block.packageddraconic.fusion_crafter.injectors." + i2), (Object[])new Object[]{usableInjectors}));
        }
        if (usable.getSiblings().isEmpty()) {
            message.append(" 0");
        } else {
            message.append("\n");
            message.append((Component)usable);
        }
        if (Arrays.stream(this.requiredInjectors).anyMatch(i -> i > 0)) {
            message.append("\n");
            message.append((Component)Component.translatable((String)"block.packageddraconic.fusion_crafter.injectors.required"));
            int[] actualRequiredInjectors = new int[]{this.requiredInjectors[0] - this.requiredInjectors[1] - this.requiredInjectors[2] - this.requiredInjectors[3], this.requiredInjectors[1] - this.requiredInjectors[2] - this.requiredInjectors[3], this.requiredInjectors[2] - this.requiredInjectors[3], this.requiredInjectors[3]};
            MutableComponent required = Component.literal((String)" ");
            for (int i3 = 0; i3 <= 3; ++i3) {
                int requiredInjectors = actualRequiredInjectors[i3];
                if (requiredInjectors <= 0) continue;
                if (!required.getSiblings().isEmpty()) {
                    required.append(", ");
                }
                required.append((Component)Component.translatable((String)("block.packageddraconic.fusion_crafter.injectors." + i3), (Object[])new Object[]{requiredInjectors}));
            }
            message.append("\n");
            message.append((Component)required);
        }
        return message;
    }

    public void tick() {
        if (!this.level.isClientSide) {
            if (this.isWorking) {
                this.tickProcess();
            }
            this.chargeEnergy();
            if (this.level.getGameTime() % 8L == 0L) {
                this.ejectItems();
            }
        } else {
            this.fxHandler.run();
        }
    }

    public boolean acceptPackage(IPackageRecipeInfo recipeInfo, List<ItemStack> stacks, Direction direction) {
        if (!this.isBusy() && recipeInfo.isValid() && recipeInfo instanceof IFusionPackageRecipeInfo) {
            IFusionPackageRecipeInfo recipe = (IFusionPackageRecipeInfo)recipeInfo;
            int tier = recipe.getTierRequired();
            List<ItemStack> injectorInputs = recipe.getInjectorInputs();
            List<BlockPos> emptyInjectors = this.getEmptyInjectors(tier);
            this.requiredInjectors[tier] = Math.max(this.requiredInjectors[tier], injectorInputs.size());
            if (emptyInjectors.size() >= injectorInputs.size()) {
                MarkedInjectorBlockEntity injector;
                int i;
                this.injectors.clear();
                this.injectors.addAll(emptyInjectors.subList(0, injectorInputs.size()));
                this.currentRecipe = recipe;
                this.effectRecipe = recipe.getRecipeHolder();
                this.isWorking = true;
                this.fusionState = IFusionStateMachine.FusionState.START;
                this.itemHandler.setStackInSlot(0, recipe.getCoreInput().copy());
                List<IFusionInjector> craftInjectors = this.getInjectors();
                for (i = 0; i < craftInjectors.size(); ++i) {
                    injector = (MarkedInjectorBlockEntity)craftInjectors.get(i);
                    injector.setInjectorStack(injectorInputs.get(i).copy());
                    injector.setCrafter(this);
                }
                if (!recipe.getRecipe().matches((IFusionInventory)this, this.level) || !recipe.getRecipe().canStartCraft((IFusionInventory)this, this.level, t -> {})) {
                    this.injectors.clear();
                    this.currentRecipe = null;
                    this.effectRecipe = null;
                    this.isWorking = false;
                    this.itemHandler.setStackInSlot(0, ItemStack.EMPTY);
                    for (i = 0; i < craftInjectors.size(); ++i) {
                        injector = (MarkedInjectorBlockEntity)craftInjectors.get(i);
                        injector.setInjectorStack(ItemStack.EMPTY);
                        injector.setCrafter(this);
                    }
                    return false;
                }
                this.setChanged();
                return true;
            }
        }
        return false;
    }

    public boolean isBusy() {
        return this.isWorking || !this.itemHandler.getStacks().subList(0, 2).stream().allMatch(ItemStack::isEmpty);
    }

    protected void tickProcess() {
        if (this.injectors.stream().map(arg_0 -> ((Level)this.level).getBlockEntity(arg_0)).anyMatch(be -> !(be instanceof MarkedInjectorBlockEntity) || be.isRemoved())) {
            this.cancelCraft();
        } else {
            SyncCrafterPacket.sync(this);
            if (this.fusionState.ordinal() < IFusionStateMachine.FusionState.CRAFTING.ordinal()) {
                this.currentRecipe.getRecipe().tickFusionState((IFusionStateMachine)this, (IFusionInventory)this, this.level);
            } else if (this.energyStorage.extractEnergy(energyUsage, true) == energyUsage) {
                this.energyStorage.extractEnergy(energyUsage, false);
                this.currentRecipe.getRecipe().tickFusionState((IFusionStateMachine)this, (IFusionInventory)this, this.level);
            }
        }
    }

    public void endProcess() {
        this.fusionCounter = 0;
        this.progress = 0;
        this.animProgress = 0.0f;
        this.animLength = 0;
        this.injectors.stream().map(arg_0 -> ((Level)this.level).getBlockEntity(arg_0)).filter(be -> be instanceof MarkedInjectorBlockEntity && !be.isRemoved()).forEach(be -> ((MarkedInjectorBlockEntity)((Object)be)).ejectItem());
        this.injectors.clear();
        this.isWorking = false;
        this.minTier = -1;
        this.effectRecipe = null;
        this.currentRecipe = null;
        this.setChanged();
    }

    protected List<BlockPos> getEmptyInjectors(int minTier) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (int i = 3; i >= minTier; --i) {
            positions.addAll(this.getEmptyInjectorsForTier(i));
        }
        return positions;
    }

    protected List<BlockPos> getEmptyInjectorsForTier(int tier) {
        int range = DEConfig.fusionInjectorRange;
        int radius = 1;
        return Streams.concat((Stream[])new Stream[]{BlockPos.betweenClosedStream((BlockPos)this.worldPosition.offset(-range, -radius, -radius), (BlockPos)this.worldPosition.offset(range, radius, radius)), BlockPos.betweenClosedStream((BlockPos)this.worldPosition.offset(-radius, -range, -radius), (BlockPos)this.worldPosition.offset(radius, range, radius)), BlockPos.betweenClosedStream((BlockPos)this.worldPosition.offset(-radius, -radius, -range), (BlockPos)this.worldPosition.offset(radius, radius, range))}).map(checkPos -> {
            BlockEntity be = this.level.getBlockEntity(checkPos);
            if (be instanceof MarkedInjectorBlockEntity) {
                MarkedInjectorBlockEntity injector = (MarkedInjectorBlockEntity)be;
                BlockPos dirVec = checkPos.subtract((Vec3i)this.worldPosition);
                int dist = Ints.max((int[])new int[]{Math.abs(dirVec.getX()), Math.abs(dirVec.getY()), Math.abs(dirVec.getZ())});
                if (dist > DEConfig.fusionInjectorMinDist && injector.getInjectorTier().index == tier && injector.getInjectorStack().isEmpty() && Direction.getNearest((float)dirVec.getX(), (float)dirVec.getY(), (float)dirVec.getZ()) == injector.getDirection().getOpposite()) {
                    Direction facing = injector.getDirection();
                    for (BlockPos bp : BlockPos.betweenClosed((BlockPos)checkPos.relative(facing), (BlockPos)checkPos.relative(facing, FusionCrafterBlockEntity.distanceInDirection(checkPos, this.worldPosition, facing) - 1))) {
                        BlockState state = this.level.getBlockState(bp);
                        BlockEntity bbe = this.level.getBlockEntity(bp);
                        if ((state.isAir() || bbe instanceof PackagerBlockEntity || bbe instanceof PackagerExtensionBlockEntity || bbe instanceof UnpackagerBlockEntity || bbe instanceof PackagingProviderBlockEntity || !state.canOcclude()) && !(bbe instanceof MarkedInjectorBlockEntity) && !(bbe instanceof FusionCrafterBlockEntity)) continue;
                        return null;
                    }
                    return checkPos.immutable();
                }
            }
            return null;
        }).filter(Objects::nonNull).toList();
    }

    public List<IFusionInjector> getInjectors() {
        return this.injectors.stream().map(arg_0 -> ((Level)this.level).getBlockEntity(arg_0)).filter(be -> be instanceof MarkedInjectorBlockEntity && !be.isRemoved()).map(be -> (IFusionInjector)be).toList();
    }

    public static int distanceInDirection(BlockPos fromPos, BlockPos toPos, Direction direction) {
        return switch (direction) {
            case Direction.DOWN -> fromPos.getY() - toPos.getY();
            case Direction.UP -> toPos.getY() - fromPos.getY();
            case Direction.NORTH -> fromPos.getZ() - toPos.getZ();
            case Direction.SOUTH -> toPos.getZ() - fromPos.getZ();
            case Direction.WEST -> fromPos.getX() - toPos.getX();
            case Direction.EAST -> toPos.getX() - fromPos.getX();
            default -> 0;
        };
    }

    protected void ejectItems() {
        int endIndex = this.isWorking ? 1 : 0;
        for (Direction direction : Direction.values()) {
            BlockPos offsetPos = this.worldPosition.relative(direction);
            Block block = this.level.getBlockState(offsetPos).getBlock();
            IItemHandler itemHandler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, offsetPos, (Object)direction.getOpposite());
            if (block == PackagedAutoBlocks.UNPACKAGER.get() || itemHandler == null) continue;
            for (int i = 1; i >= endIndex; --i) {
                ItemStack stack = this.itemHandler.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                ItemStack stackRem = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false);
                this.itemHandler.setStackInSlot(i, stackRem);
            }
        }
    }

    protected void chargeEnergy() {
        ItemStack energyStack = this.itemHandler.getStackInSlot(2);
        IEnergyStorage itemEnergyStorage = (IEnergyStorage)energyStack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (itemEnergyStorage != null) {
            int energyRequest = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            this.energyStorage.receiveEnergy(itemEnergyStorage.extractEnergy(energyRequest, false), false);
            if (energyStack.getCount() <= 0) {
                this.itemHandler.setStackInSlot(2, ItemStack.EMPTY);
            }
        }
    }

    public ItemStack getCatalystStack() {
        return this.itemHandler.getStackInSlot(0);
    }

    public ItemStack getOutputStack() {
        return this.itemHandler.getStackInSlot(1);
    }

    public void setCatalystStack(ItemStack stack) {
        this.itemHandler.setStackInSlot(0, stack);
    }

    public void setOutputStack(ItemStack stack) {
        this.itemHandler.setStackInSlot(1, stack);
    }

    public ItemStack getItem(int index) {
        if (index <= 0) {
            return this.itemHandler.getStackInSlot(0);
        }
        List<IFusionInjector> injectors = this.getInjectors();
        return --index >= injectors.size() ? ItemStack.EMPTY : injectors.get(index).getInjectorStack();
    }

    public int size() {
        return this.getInjectors().size() + 1;
    }

    public TechLevel getMinimumTier() {
        if (this.minTier == -1) {
            this.minTier = this.getInjectors().stream().mapToInt(c -> c.getInjectorTier().index).min().orElse(-1);
        }
        return TechLevel.byIndex((int)this.minTier);
    }

    public IFusionStateMachine.FusionState getFusionState() {
        return this.fusionState;
    }

    public void setFusionState(IFusionStateMachine.FusionState state) {
        this.fusionState = state;
        this.setChanged();
    }

    public void completeCraft() {
        this.isWorking = false;
        this.getInjectors().forEach(e -> e.setEnergyRequirement(0L, 0L));
        FinishCraftEffectsPacket.finishCraft(this, true);
        this.ejectItems();
        this.endProcess();
    }

    public void cancelCraft() {
        this.isWorking = false;
        this.getInjectors().forEach(e -> e.setEnergyRequirement(0L, 0L));
        FinishCraftEffectsPacket.finishCraft(this, false);
        this.ejectItems();
        this.endProcess();
    }

    public int getCounter() {
        return this.fusionCounter;
    }

    public void setCounter(int count) {
        this.fusionCounter = count;
        this.setChanged();
    }

    public void setFusionStatus(double progress, Component stateText) {
        if (progress < 0.0) {
            this.progress = 0;
        }
        this.progress = switch (this.fusionState) {
            case IFusionStateMachine.FusionState.CHARGING -> (short)(progress * 10000.0);
            case IFusionStateMachine.FusionState.CRAFTING -> (short)(10000.0 + progress * 10000.0);
            default -> (short)(progress * 20000.0);
        };
        this.setChanged();
    }

    public void setCraftAnimation(float progress, int length) {
        this.animProgress = progress;
        this.animLength = (short)length;
        this.setChanged();
    }

    public int getComparatorSignal() {
        if (this.isWorking) {
            return 1;
        }
        if (!this.itemHandler.getStacks().subList(0, 2).stream().allMatch(ItemStack::isEmpty)) {
            return 15;
        }
        return 0;
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        CompoundTag tag;
        IPackageRecipeInfo recipe;
        super.loadAdditional(nbt, registries);
        this.fusionState = IFusionStateMachine.FusionState.values()[nbt.getByte("fusion_state")];
        this.progress = nbt.getShort("progress");
        this.animProgress = nbt.getFloat("anim_progress");
        this.animLength = nbt.getShort("anim_length");
        this.fusionCounter = nbt.getInt("fusion_counter");
        this.currentRecipe = null;
        if (nbt.contains("recipe") && (recipe = MiscHelper.INSTANCE.loadRecipe(tag = nbt.getCompound("recipe"), registries)) instanceof IFusionPackageRecipeInfo) {
            IFusionPackageRecipeInfo fusionRecipe;
            this.currentRecipe = fusionRecipe = (IFusionPackageRecipeInfo)recipe;
        }
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.putByte("fusion_state", (byte)this.fusionState.ordinal());
        nbt.putShort("progress", this.progress);
        nbt.putFloat("anim_progress", this.animProgress);
        nbt.putShort("anim_length", this.animLength);
        nbt.putInt("fusion_counter", this.fusionCounter);
        if (this.currentRecipe != null) {
            CompoundTag tag = MiscHelper.INSTANCE.saveRecipe(new CompoundTag(), (IPackageRecipeInfo)this.currentRecipe, registries);
            nbt.put("recipe", (Tag)tag);
        }
    }

    public void loadSync(CompoundTag nbt, HolderLookup.Provider registries) {
        Recipe recipe;
        Optional recipe2;
        super.loadSync(nbt, registries);
        this.isWorking = nbt.getBoolean("working");
        this.itemHandler.load(nbt, registries);
        this.injectors.clear();
        ListTag injectorsTag = nbt.getList("injectors", 11);
        for (int i = 0; i < injectorsTag.size(); ++i) {
            int[] posArray = injectorsTag.getIntArray(i);
            BlockPos pos = new BlockPos(posArray[0], posArray[1], posArray[2]);
            this.injectors.add(pos);
        }
        this.effectRecipe = null;
        if (nbt.contains("effect_recipe") && (recipe2 = MiscHelper.INSTANCE.getRecipeManager().byKey(ResourceLocation.parse((String)nbt.getString("effect_recipe")))).isPresent() && (recipe = ((RecipeHolder)recipe2.get()).value()) instanceof IFusionRecipe) {
            IFusionRecipe fusionRecipe = (IFusionRecipe)recipe;
            this.effectRecipe = new RecipeHolder(((RecipeHolder)recipe2.get()).id(), (Recipe)fusionRecipe);
        }
    }

    /*
     * Exception decompiling
     */
    public CompoundTag saveSync(CompoundTag nbt, HolderLookup.Provider registries) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int getScaledEnergy(int scale) {
        if (this.energyStorage.getMaxEnergyStored() <= 0) {
            return 0;
        }
        return Math.min(scale * this.energyStorage.getEnergyStored() / this.energyStorage.getMaxEnergyStored(), scale);
    }

    public int getScaledProgress(int scale) {
        if (this.progress <= 0) {
            return 0;
        }
        return scale * this.progress / 20000;
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
        this.sync(false);
        return new FusionCrafterMenu(windowId, inventory, this);
    }

    private static /* synthetic */ void lambda$saveSync$16(ListTag injectorsTag, int[] arr) {
        injectorsTag.add((Object)new IntArrayTag(arr));
    }
}

