/*
 * Decompiled with CFR 0.152.
 */
package thelm.packageddraconic.integration.appeng.blockentity;

import appeng.api.config.Actionable;
import appeng.api.features.IPlayerRegistry;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import thelm.packageddraconic.block.entity.MarkedInjectorBlockEntity;

public class AEMarkedInjectorBlockEntity
extends MarkedInjectorBlockEntity
implements IInWorldGridNodeHost,
IGridNodeListener<AEMarkedInjectorBlockEntity>,
IActionHost {
    public boolean firstTick = true;
    public IActionSource source = IActionSource.ofMachine((IActionHost)this);
    public IManagedGridNode gridNode;

    public AEMarkedInjectorBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    public void tick() {
        if (this.firstTick) {
            this.firstTick = false;
            this.getMainNode().create(this.level, this.worldPosition);
        }
        super.tick();
    }

    public void setRemoved() {
        super.setRemoved();
        if (this.gridNode != null) {
            this.gridNode.destroy();
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (this.gridNode != null) {
            this.gridNode.destroy();
        }
    }

    public IGridNode getGridNode(Direction dir) {
        return this.getActionableNode();
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.SMART;
    }

    public void onSaveChanges(AEMarkedInjectorBlockEntity nodeOwner, IGridNode node) {
        this.setChanged();
    }

    public IManagedGridNode getMainNode() {
        if (this.gridNode == null) {
            this.gridNode = GridHelper.createManagedNode((Object)((Object)this), (IGridNodeListener)this);
            this.gridNode.setTagName("node");
            this.gridNode.setVisualRepresentation((ItemLike)this.getBlockState().getBlock());
            this.gridNode.setGridColor(AEColor.TRANSPARENT);
            this.gridNode.setIdlePowerUsage(1.0);
            this.gridNode.setInWorldNode(true);
            if (this.ownerUUID != null && this.level instanceof ServerLevel) {
                this.gridNode.setOwningPlayerId(IPlayerRegistry.getMapping((Level)this.level).getPlayerId(this.ownerUUID));
            }
        }
        return this.gridNode;
    }

    public IGridNode getActionableNode() {
        return this.getMainNode().getNode();
    }

    @Override
    public void ejectItem() {
        if (this.getMainNode().isActive()) {
            IGrid grid = this.getMainNode().getGrid();
            IStorageService storageService = grid.getStorageService();
            IEnergyService energyService = grid.getEnergyService();
            MEStorage inventory = storageService.getInventory();
            ItemStack is = this.itemHandler.getStackInSlot(0);
            if (!is.isEmpty()) {
                int count;
                AEItemKey key = AEItemKey.of((ItemStack)is);
                int inserted = (int)StorageHelper.poweredInsert((IEnergySource)energyService, (MEStorage)inventory, (AEKey)key, (long)(count = is.getCount()), (IActionSource)this.source, (Actionable)Actionable.MODULATE);
                if (inserted == count) {
                    this.itemHandler.setStackInSlot(0, ItemStack.EMPTY);
                } else {
                    this.itemHandler.setStackInSlot(0, key.toStack(count - inserted));
                }
            }
        }
        super.ejectItem();
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        if (nbt.contains("node")) {
            this.getMainNode().loadFromNBT(nbt);
        }
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        if (this.gridNode != null) {
            this.gridNode.saveToNBT(nbt);
        }
    }
}

