/*
 * Decompiled with CFR 0.152.
 */
package thelm.packageddraconic.integration.patchouli.component;

import codechicken.lib.math.MathHelper;
import com.brandon3055.draconicevolution.api.crafting.IFusionRecipe;
import com.google.gson.annotations.SerializedName;
import java.util.function.UnaryOperator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import thelm.packagedauto.util.MiscHelper;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.ICustomComponent;
import vazkii.patchouli.api.IVariable;

public class FusionRecipeItemListComponent
implements ICustomComponent {
    @SerializedName(value="recipe")
    public IVariable recipeRaw;
    transient IFusionRecipe fusionRecipe;
    transient int x;
    transient int y;

    public void onVariablesAvailable(UnaryOperator<IVariable> lookup, HolderLookup.Provider registries) {
        ResourceLocation recipeId = ResourceLocation.parse((String)((IVariable)lookup.apply(this.recipeRaw)).asString());
        Recipe recipe = MiscHelper.INSTANCE.getRecipeManager().byKey(recipeId).map(RecipeHolder::value).orElse(null);
        if (recipe instanceof IFusionRecipe) {
            IFusionRecipe fusionRecipe;
            this.fusionRecipe = fusionRecipe = (IFusionRecipe)recipe;
        }
    }

    public void build(int componentX, int componentY, int pageNum) {
        this.x = componentX < 0 ? 50 : componentX;
        this.y = componentY < 0 ? 43 : componentY;
    }

    public void render(GuiGraphics guiGraphics, IComponentRenderContext context, float partialTicks, int mouseX, int mouseY) {
        if (this.fusionRecipe != null) {
            NonNullList ingredients = this.fusionRecipe.getIngredients();
            float degreePerInput = 360.0f / (float)ingredients.size();
            int ticksElapsed = context.getTicksInBook();
            float currentDegree = (Screen.hasShiftDown() ? (float)ticksElapsed : (float)ticksElapsed + partialTicks) - 90.0f;
            for (Ingredient ingredient : ingredients) {
                double radians = Math.toRadians(currentDegree);
                double xPos = (double)this.x + Math.cos(radians) * 32.0;
                double yPos = (double)this.y + Math.sin(radians) * 32.0;
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate(xPos - (double)MathHelper.floor((double)xPos), yPos - (double)MathHelper.floor((double)yPos), 0.0);
                context.renderIngredient(guiGraphics, MathHelper.floor((double)xPos), MathHelper.floor((double)yPos), mouseX, mouseY, ingredient);
                guiGraphics.pose().popPose();
                currentDegree += degreePerInput;
            }
        }
    }
}

