/*
 * Decompiled with CFR 0.152.
 */
package thelm.packageddraconic.packet;

import com.brandon3055.brandonscore.client.particle.IntParticleData;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.handlers.DESounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import thelm.packageddraconic.block.entity.FusionCrafterBlockEntity;

public record FinishCraftEffectsPacket(BlockPos pos, boolean doParticles) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<FinishCraftEffectsPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.parse((String)"packageddraconic:finish_craft_effects"));
    public static final StreamCodec<RegistryFriendlyByteBuf, FinishCraftEffectsPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, FinishCraftEffectsPacket::pos, (StreamCodec)ByteBufCodecs.BOOL, FinishCraftEffectsPacket::doParticles, FinishCraftEffectsPacket::new);

    public CustomPacketPayload.Type<FinishCraftEffectsPacket> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            ClientLevel level = Minecraft.getInstance().level;
            if (level.isLoaded(this.pos)) {
                if (this.doParticles) {
                    level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, (double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5, 1.0, 0.0, 0.0);
                    for (int i = 0; i < 100; ++i) {
                        double velX = (level.random.nextDouble() - 0.5) * 0.1;
                        double velY = (level.random.nextDouble() - 0.5) * 0.1;
                        double velZ = (level.random.nextDouble() - 0.5) * 0.1;
                        level.addParticle((ParticleOptions)new IntParticleData((ParticleType)DEParticles.ENERGY_BASIC.get(), new Integer[]{0, 255, 255, 64}), (double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5, velX, velY, velZ);
                    }
                }
                level.playLocalSound((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5, (SoundEvent)DESounds.FUSION_COMPLETE.get(), SoundSource.BLOCKS, 4.0f, (1.0f + (level.random.nextFloat() - level.random.nextFloat()) * 0.2f) * 0.7f, false);
            }
        });
    }

    public static void finishCraft(FusionCrafterBlockEntity crafter, boolean doParticles) {
        Level level = crafter.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            double x = (double)crafter.getBlockPos().getX() + 0.5;
            double y = (double)crafter.getBlockPos().getY() + 0.5;
            double z = (double)crafter.getBlockPos().getZ() + 0.5;
            PacketDistributor.sendToPlayersNear((ServerLevel)level2, null, (double)x, (double)y, (double)z, (double)32.0, (CustomPacketPayload)new FinishCraftEffectsPacket(crafter.getBlockPos(), doParticles), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

