/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.internal.common.blocks;

import mod.azure.azurelib.common.internal.common.blocks.TickingLightBlock;
import mod.azure.azurelib.common.internal.common.registry.AzureBlocksEntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TickingLightEntity
extends BlockEntity {
    private int lifespan = 0;

    public TickingLightEntity(BlockPos blockPos, BlockState blockState) {
        super(AzureBlocksEntityRegistry.TICKING_LIGHT_ENTITY.get(), blockPos, blockState);
    }

    public static void tick(Level world, BlockPos blockPos, BlockState blockState, TickingLightEntity blockEntity) {
        blockEntity.tick();
    }

    public void refresh(int lifeExtension) {
        this.lifespan = -lifeExtension;
    }

    private void tick() {
        if (this.lifespan++ >= 5) {
            if (this.level.getBlockState(this.getBlockPos()).getBlock() instanceof TickingLightBlock) {
                this.level.setBlockAndUpdate(this.getBlockPos(), Blocks.AIR.defaultBlockState());
            } else {
                this.setRemoved();
            }
        }
    }
}

