/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.armor;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import mod.azure.azurelib.rewrite.animation.AzAnimator;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzLayerRenderer;
import mod.azure.azurelib.rewrite.render.AzModelRenderer;
import mod.azure.azurelib.rewrite.render.AzRendererConfig;
import mod.azure.azurelib.rewrite.render.AzRendererPipeline;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.armor.AzArmorModelRenderer;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRendererPipeline;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.armor.bone.AzArmorBoneProvider;
import mod.azure.azurelib.rewrite.render.armor.bone.AzDefaultArmorBoneProvider;
import mod.azure.azurelib.rewrite.render.layer.AzRenderLayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class AzArmorRendererConfig
extends AzRendererConfig<ItemStack> {
    private final AzArmorBoneProvider boneProvider;

    private AzArmorRendererConfig(Supplier<AzAnimator<ItemStack>> animatorProvider, AzArmorBoneProvider boneProvider, Function<ItemStack, RenderType> renderTypeProvider, Function<ItemStack, ResourceLocation> modelLocationProvider, List<AzRenderLayer<ItemStack>> renderLayers, Function<AzRendererPipelineContext<ItemStack>, AzRendererPipelineContext<ItemStack>> preRenderEntry, Function<AzRendererPipelineContext<ItemStack>, AzRendererPipelineContext<ItemStack>> renderEntry, Function<AzRendererPipelineContext<ItemStack>, AzRendererPipelineContext<ItemStack>> postRenderEntry, Function<ItemStack, ResourceLocation> textureLocationProvider, Function<ItemStack, Float> alphaFunction, Function<ItemStack, Float> scaleHeight, Function<ItemStack, Float> scaleWidth, BiFunction<AzRendererPipeline<ItemStack>, AzLayerRenderer<ItemStack>, AzModelRenderer<ItemStack>> modelRendererProvider, Function<AzRendererPipeline<ItemStack>, AzRendererPipelineContext<ItemStack>> pipelineContextFunction, Function<AzBone, ResourceLocation> boneTextureOverrideProvider, Function<AzBone, RenderType> boneRenderTypeOverrideProvider) {
        super(animatorProvider, modelLocationProvider, modelRendererProvider, pipelineContextFunction, renderTypeProvider, renderLayers, preRenderEntry, renderEntry, postRenderEntry, textureLocationProvider, alphaFunction, scaleHeight, scaleWidth, boneTextureOverrideProvider, boneRenderTypeOverrideProvider);
        this.boneProvider = boneProvider;
    }

    public AzArmorBoneProvider boneProvider() {
        return this.boneProvider;
    }

    public static Builder builder(ResourceLocation modelLocation, ResourceLocation textureLocation) {
        return new Builder($ -> modelLocation, $ -> textureLocation);
    }

    public static Builder builder(Function<ItemStack, ResourceLocation> modelLocationProvider, Function<ItemStack, ResourceLocation> textureLocationProvider) {
        return new Builder(modelLocationProvider, textureLocationProvider);
    }

    public static class Builder
    extends AzRendererConfig.Builder<ItemStack> {
        private AzArmorBoneProvider boneProvider = new AzDefaultArmorBoneProvider();

        protected Builder(Function<ItemStack, ResourceLocation> modelLocationProvider, Function<ItemStack, ResourceLocation> textureLocationProvider) {
            super(modelLocationProvider, textureLocationProvider);
            this.modelRendererProvider = (entityRendererPipeline, layer) -> new AzArmorModelRenderer((AzArmorRendererPipeline)entityRendererPipeline, (AzLayerRenderer<ItemStack>)layer);
            this.pipelineContextFunction = AzArmorRendererPipelineContext::new;
            this.renderTypeProvider = $ -> RenderType.entityTranslucentCull((ResourceLocation)((ResourceLocation)textureLocationProvider.apply((ItemStack)$)));
        }

        public Builder setBoneRenderTypeOverrideProvider(Function<AzBone, RenderType> boneRenderTypeOverrideProvider) {
            return (Builder)super.setBoneRenderTypeOverrideProvider(boneRenderTypeOverrideProvider);
        }

        public Builder setBoneTextureOverrideProvider(Function<AzBone, ResourceLocation> boneTextureOverrideProvider) {
            return (Builder)super.setBoneTextureOverrideProvider(boneTextureOverrideProvider);
        }

        public Builder setModelRenderer(BiFunction<AzRendererPipeline<ItemStack>, AzLayerRenderer<ItemStack>, AzModelRenderer<ItemStack>> modelRendererProvider) {
            return (Builder)super.setModelRenderer(modelRendererProvider);
        }

        public Builder setPipelineContext(Function<AzRendererPipeline<ItemStack>, AzRendererPipelineContext<ItemStack>> azRendererPipelineAzRendererPipelineContextFunction) {
            return (Builder)super.setPipelineContext(azRendererPipelineAzRendererPipelineContextFunction);
        }

        public Builder addRenderLayer(AzRenderLayer<ItemStack> renderLayer) {
            return (Builder)super.addRenderLayer(renderLayer);
        }

        public Builder setRenderType(RenderType renderType) {
            this.renderTypeProvider = $ -> renderType;
            return this;
        }

        public Builder setRenderType(Function<ItemStack, RenderType> renderTypeProvider) {
            this.renderTypeProvider = renderTypeProvider;
            return this;
        }

        public Builder setPrerenderEntry(Function<AzRendererPipelineContext<ItemStack>, AzRendererPipelineContext<ItemStack>> preRenderEntry) {
            return (Builder)super.setPrerenderEntry(preRenderEntry);
        }

        public Builder setRenderEntry(Function<AzRendererPipelineContext<ItemStack>, AzRendererPipelineContext<ItemStack>> renderEntry) {
            return (Builder)super.setRenderEntry(renderEntry);
        }

        public Builder setPostRenderEntry(Function<AzRendererPipelineContext<ItemStack>, AzRendererPipelineContext<ItemStack>> preRenderEntry) {
            return (Builder)super.setPostRenderEntry(preRenderEntry);
        }

        public Builder setAnimatorProvider(Supplier<@Nullable AzAnimator<ItemStack>> animatorProvider) {
            return (Builder)super.setAnimatorProvider(animatorProvider);
        }

        public Builder setBoneProvider(AzArmorBoneProvider boneProvider) {
            this.boneProvider = boneProvider;
            return this;
        }

        public Builder setAlpha(Function<ItemStack, Float> alphaFunction) {
            return (Builder)super.setAlpha(alphaFunction);
        }

        public Builder setAlpha(float alpha) {
            return (Builder)super.setAlpha(alpha);
        }

        public Builder setScale(Function<ItemStack, Float> scaleFunction) {
            return (Builder)super.setScale(scaleFunction);
        }

        public Builder setScale(Function<ItemStack, Float> scaleHeightFunction, Function<ItemStack, Float> scaleWidthFunction) {
            return (Builder)super.setScale(scaleHeightFunction, scaleWidthFunction);
        }

        public Builder setScale(float scale) {
            return (Builder)super.setScale(scale);
        }

        public Builder setScale(float scaleWidth, float scaleHeight) {
            return (Builder)super.setScale(scaleWidth, scaleHeight);
        }

        public AzArmorRendererConfig build() {
            AzRendererConfig baseConfig = super.build();
            return new AzArmorRendererConfig(baseConfig::createAnimator, this.boneProvider, baseConfig::getRenderType, baseConfig::modelLocation, baseConfig.renderLayers(), baseConfig::preRenderEntry, baseConfig::renderEntry, baseConfig::postRenderEntry, baseConfig::textureLocation, baseConfig::alpha, baseConfig::scaleHeight, baseConfig::scaleWidth, baseConfig::modelRendererProvider, baseConfig::pipelineContext, baseConfig::boneTextureOverrideProvider, baseConfig::boneRenderTypeOverrideProvider);
        }
    }
}

