/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.item;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.stream.Stream;
import mod.azure.azurelib.common.internal.client.util.RenderUtils;
import mod.azure.azurelib.common.platform.Services;
import mod.azure.azurelib.rewrite.animation.impl.AzItemAnimator;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.model.AzBoneSnapshot;
import mod.azure.azurelib.rewrite.render.AzLayerRenderer;
import mod.azure.azurelib.rewrite.render.AzModelRenderer;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.item.AzItemArmRenderUtil;
import mod.azure.azurelib.rewrite.render.item.AzItemRendererConfig;
import mod.azure.azurelib.rewrite.render.item.AzItemRendererPipeline;
import mod.azure.azurelib.rewrite.render.item.AzItemRendererPipelineContext;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class AzItemModelRenderer
extends AzModelRenderer<ItemStack> {
    protected final AzItemRendererPipeline itemRendererPipeline;

    public AzItemModelRenderer(AzItemRendererPipeline itemRendererPipeline, AzLayerRenderer<ItemStack> layerRenderer) {
        super(itemRendererPipeline, layerRenderer);
        this.itemRendererPipeline = itemRendererPipeline;
    }

    @Override
    public void render(AzRendererPipelineContext<ItemStack> context, boolean isReRender) {
        boolean firstPerson;
        if (!isReRender) {
            ItemStack animatable = context.animatable();
            AzItemAnimator animator = this.itemRendererPipeline.getRenderer().getAnimator();
            if (animator != null) {
                this.handleAnimation(animator, animatable, context.partialTick());
            }
        }
        PoseStack poseStack = context.poseStack();
        this.itemRendererPipeline.modelRenderTranslations = new Matrix4f((Matrix4fc)poseStack.last().pose());
        AzItemRendererPipelineContext itemContext = (AzItemRendererPipelineContext)this.itemRendererPipeline.context();
        ItemDisplayContext transformType = itemContext.getTransformType();
        boolean bl = firstPerson = transformType == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || transformType == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND;
        if (!firstPerson) {
            Stream.of("leftArm", "rightArm").forEach(boneName -> this.itemRendererPipeline.context().bakedModel().getBone((String)boneName).ifPresent(bone -> bone.setHidden(true)));
        }
        super.render(context, isReRender);
    }

    @Override
    public void renderRecursively(AzRendererPipelineContext<ItemStack> context, AzBone bone, boolean isReRender) {
        AzItemRendererPipelineContext itemContext;
        PoseStack poseStack = context.poseStack();
        AzItemRendererConfig itemRendererConfig = (AzItemRendererConfig)this.itemRendererPipeline.config();
        boolean shouldFreezeTransforms = !itemRendererConfig.shouldAnimateInContext((itemContext = (AzItemRendererPipelineContext)this.itemRendererPipeline.context()).getTransformType());
        float origPosX = 0.0f;
        float origPosY = 0.0f;
        float origPosZ = 0.0f;
        float origRotX = 0.0f;
        float origRotY = 0.0f;
        float origRotZ = 0.0f;
        float origScaleX = 0.0f;
        float origScaleY = 0.0f;
        float origScaleZ = 0.0f;
        if (shouldFreezeTransforms) {
            origPosX = bone.getPosX();
            origPosY = bone.getPosY();
            origPosZ = bone.getPosZ();
            origRotX = bone.getRotX();
            origRotY = bone.getRotY();
            origRotZ = bone.getRotZ();
            origScaleX = bone.getScaleX();
            origScaleY = bone.getScaleY();
            origScaleZ = bone.getScaleZ();
            AzBoneSnapshot initialSnapshot = bone.getInitialAzSnapshot();
            bone.setPosX(initialSnapshot.getOffsetX());
            bone.setPosY(initialSnapshot.getOffsetY());
            bone.setPosZ(initialSnapshot.getOffsetZ());
            bone.setRotX(initialSnapshot.getRotX());
            bone.setRotY(initialSnapshot.getRotY());
            bone.setRotZ(initialSnapshot.getRotZ());
            bone.setScaleX(initialSnapshot.getScaleX());
            bone.setScaleY(initialSnapshot.getScaleY());
            bone.setScaleZ(initialSnapshot.getScaleZ());
        }
        poseStack.pushPose();
        if (AzItemArmRenderUtil.isArmBone(bone) && !Services.PLATFORM.isModLoaded("firstperson")) {
            AzItemArmRenderUtil.renderArmForBone(context, bone, this);
        }
        if (bone.isTrackingMatrices()) {
            ItemStack animatable = context.animatable();
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.last().pose());
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices(poseState, this.itemRendererPipeline.itemRenderTranslations);
            bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.itemRendererPipeline.modelRenderTranslations));
            bone.setLocalSpaceMatrix(RenderUtils.translateMatrix(localMatrix, this.getRenderOffset(animatable, 1.0f).toVector3f()));
        }
        context.setVertexConsumer(this.getOrRefreshRenderBuffer(isReRender, context, bone));
        super.renderRecursively(context, bone, isReRender);
        if (shouldFreezeTransforms) {
            bone.setPosX(origPosX);
            bone.setPosY(origPosY);
            bone.setPosZ(origPosZ);
            bone.setRotX(origRotX);
            bone.setRotY(origRotY);
            bone.setRotZ(origRotZ);
            bone.setScaleX(origScaleX);
            bone.setScaleY(origScaleY);
            bone.setScaleZ(origScaleZ);
        }
        poseStack.popPose();
    }

    public Vec3 getRenderOffset(ItemStack itemStack, float f) {
        return Vec3.ZERO;
    }
}

