/*
 * Decompiled with CFR 0.152.
 */
package vt.icl;

import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vt.icl.config.ConfigManager;
import vt.icl.config.Configuration;
import vt.icl.config.lang.IclTranslationManager;
import vt.icl.mixin.ItemEntityAccessor;
import vt.icl.permission.PermissionHandler;

public class ICLCommon {
    public static final String MOD_ID = "icl";
    public static final String MOD_PREFIX = "[" + "icl".toUpperCase() + "] ";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"icl".toUpperCase());
    public static final Path CONFIG_DIR = new File("./config/" + "icl".substring(0, 1).toUpperCase() + "icl".substring(1)).toPath();
    public static Configuration config = ConfigManager.getConfig();
    private static Timer TIMER = new Timer("icl".toUpperCase());
    public static Map<String, String> translations;
    private static Map<String, String> defaultTranslations;
    public static PermissionHandler permissionHandler;
    private static MinecraftServer server;

    public static void init() {
        LOGGER.info("Initializing " + MOD_ID.toUpperCase());
        IclTranslationManager.createDefaultTranslationFiles();
        translations = IclTranslationManager.loadTranslation(ICLCommon.config.NotificationLang);
        defaultTranslations = IclTranslationManager.loadTranslation("en_us");
    }

    public static void onServerStart(MinecraftServer server) {
        ICLCommon.server = server;
        if (ICLCommon.config.Delay > 0L) {
            ICLCommon.doItemClean(server);
            if (ICLCommon.config.doShowNotification) {
                ICLCommon.setupNotificationTimers(server);
            }
            if (ICLCommon.config.doNotificationCountdown) {
                ICLCommon.setupCountdownTimer(server);
            }
        } else {
            LOGGER.info(MOD_ID.toUpperCase() + " disabled, delay is less than 0");
        }
        LOGGER.info(MOD_ID.toUpperCase() + " initialized");
    }

    public static void onServerStop() {
        TIMER.cancel();
        LOGGER.info(MOD_ID.toUpperCase() + " stopped");
    }

    public static void doItemClean(final MinecraftServer server) {
        long delay = ICLCommon.config.Delay;
        if (delay < 0L) {
            return;
        }
        TIMER.schedule(new TimerTask(){

            @Override
            public void run() {
                if (ICLCommon.config.doShowNotification) {
                    ICLCommon.setupNotificationTimers(server);
                }
                if (ICLCommon.config.doNotificationCountdown) {
                    ICLCommon.setupCountdownTimer(server);
                }
                server.execute(() -> ICLCommon.clearItems(server));
                TIMER.purge();
                ICLCommon.doItemClean(server);
            }
        }, delay * 1000L);
    }

    public static void setupNotificationTimers(final MinecraftServer server) {
        for (int i = 0; i < ICLCommon.config.NotificationTimes; ++i) {
            final int finalI = i;
            long delay = ICLCommon.config.Delay - ICLCommon.config.NotificationStart + ICLCommon.config.NotificationDelay * (long)i;
            if (delay < 0L || delay > ICLCommon.config.Delay) continue;
            TIMER.schedule(new TimerTask(){

                @Override
                public void run() {
                    LOGGER.info("{} seconds left", (Object)("Clearing items " + (ICLCommon.config.NotificationStart - ICLCommon.config.NotificationDelay * (long)finalI)));
                    for (ServerPlayer player : server.getPlayerList().getPlayers()) {
                        MutableComponent message = Component.literal((String)(MOD_PREFIX + ICLCommon.IclTranslate("text.icl.notification", ICLCommon.config.NotificationStart - ICLCommon.config.NotificationDelay * (long)finalI) + " ")).withStyle(ChatFormatting.valueOf((String)ICLCommon.config.NotificationColor));
                        ICLCommon.IclMessage(player, message);
                        try {
                            if (!ICLCommon.config.doNotificationSound) continue;
                            ICLCommon.IclPlaysound(player, false);
                        }
                        catch (Exception e) {
                            player.sendSystemMessage((Component)Component.literal((String)e.getMessage()).withStyle(ChatFormatting.valueOf((String)ICLCommon.config.NotificationColor)));
                            LOGGER.error("Failed to play sound: " + e.getMessage());
                        }
                    }
                }
            }, delay * 1000L);
        }
    }

    private static void IclMessage(ServerPlayer player, MutableComponent message) {
        if (ICLCommon.permissionCheckforCancel(player.createCommandSourceStack())) {
            message.append((Component)Component.literal((String)ICLCommon.IclTranslate("text.icl.cancel.button", new Object[0])).withStyle(style -> style.withClickEvent(ICLCommon.IclCancelEvent())).withStyle(ChatFormatting.RED));
        }
        player.sendSystemMessage((Component)message);
    }

    public static void setupCountdownTimer(final MinecraftServer server) {
        long delay;
        long countdownstart = ICLCommon.config.CountdownStart;
        if (countdownstart > ICLCommon.config.Delay) {
            countdownstart = ICLCommon.config.Delay;
        }
        if ((delay = ICLCommon.config.Delay - countdownstart) < 0L || delay > ICLCommon.config.Delay) {
            return;
        }
        if (countdownstart < 0L) {
            return;
        }
        final long finalCountdownstart = countdownstart;
        TIMER.schedule(new TimerTask(){

            @Override
            public void run() {
                int i = 0;
                while ((long)i < finalCountdownstart) {
                    final int finalI = i++;
                    TIMER.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            LOGGER.info("{} seconds left", (Object)("Clearing items " + (finalCountdownstart - (long)finalI)));
                            for (ServerPlayer player : server.getPlayerList().getPlayers()) {
                                MutableComponent message = Component.literal((String)(MOD_PREFIX + ICLCommon.IclTranslate("text.icl.countdown", finalCountdownstart - (long)finalI) + " ")).withStyle(ChatFormatting.valueOf((String)ICLCommon.config.NotificationColor));
                                ICLCommon.IclMessage(player, message);
                            }
                        }
                    }, (long)finalI * 1000L);
                }
            }
        }, delay * 1000L);
    }

    public static void clearItems(MinecraftServer server) {
        LOGGER.info("Clearing items");
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            if (!ICLCommon.config.doShowNotification) continue;
            player.sendSystemMessage((Component)Component.literal((String)(MOD_PREFIX + ICLCommon.IclTranslate("text.icl.clear", new Object[0]))).withStyle(ChatFormatting.valueOf((String)ICLCommon.config.NotificationColor)));
            try {
                if (!ICLCommon.config.doLastNotificationSound) continue;
                ICLCommon.IclPlaysound(player, true);
            }
            catch (Exception e) {
                player.sendSystemMessage((Component)Component.literal((String)e.getMessage()).withStyle(ChatFormatting.valueOf((String)ICLCommon.config.NotificationColor)));
                LOGGER.error("Failed to play sound: " + e.getMessage());
            }
        }
        int count = 0;
        for (ServerLevel world : server.getAllLevels()) {
            for (ItemEntity entity : world.getEntities(EntityTypeTest.forClass(ItemEntity.class), Entity::isAlive)) {
                ItemEntityAccessor accessor;
                if (ICLCommon.config.preserveNoPickupItems && (accessor = (ItemEntityAccessor)entity).getPickupDelay() == Short.MAX_VALUE || ICLCommon.config.preserveNoDespawnItems && entity.getAge() == Short.MIN_VALUE) continue;
                count += entity.getItem().getCount();
                entity.remove(Entity.RemovalReason.DISCARDED);
            }
        }
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            if (!ICLCommon.config.doShowNotification) continue;
            player.sendSystemMessage((Component)Component.literal((String)(MOD_PREFIX + ICLCommon.IclTranslate("text.icl.clear.finish", count))).withStyle(ChatFormatting.valueOf((String)ICLCommon.config.NotificationColor)));
        }
        LOGGER.info("Items cleared: {}", (Object)count);
    }

    public static void reloadIcl() {
        TIMER.cancel();
        TIMER = new Timer(MOD_ID.toUpperCase());
        config = ConfigManager.getConfig();
        if (ICLCommon.config.Delay > 0L) {
            ICLCommon.doItemClean(server);
            if (ICLCommon.config.doShowNotification) {
                ICLCommon.setupNotificationTimers(server);
            }
            if (ICLCommon.config.doNotificationCountdown) {
                ICLCommon.setupCountdownTimer(server);
            }
        } else {
            LOGGER.info(MOD_ID.toUpperCase() + " disabled, delay is less than 0");
        }
    }

    public static void CancelIcl(int tempDelay) {
        TIMER.cancel();
        TIMER = new Timer(MOD_ID.toUpperCase());
        if (tempDelay > 0) {
            TIMER.schedule(new TimerTask(){

                @Override
                public void run() {
                    config = ConfigManager.getConfig();
                    if (ICLCommon.config.Delay > 0L) {
                        ICLCommon.doItemClean(server);
                        if (ICLCommon.config.doShowNotification) {
                            ICLCommon.setupNotificationTimers(server);
                        }
                        if (ICLCommon.config.doNotificationCountdown) {
                            ICLCommon.setupCountdownTimer(server);
                        }
                    } else {
                        LOGGER.info(ICLCommon.MOD_ID.toUpperCase() + " disabled, delay is less than 0");
                    }
                }
            }, (long)tempDelay * 1000L);
        } else {
            config = ConfigManager.getConfig();
            if (ICLCommon.config.Delay > 0L) {
                ICLCommon.doItemClean(server);
                if (ICLCommon.config.doShowNotification) {
                    ICLCommon.setupNotificationTimers(server);
                }
                if (ICLCommon.config.doNotificationCountdown) {
                    ICLCommon.setupCountdownTimer(server);
                }
            } else {
                LOGGER.info(MOD_ID.toUpperCase() + " disabled, delay is less than 0");
            }
        }
    }

    public static ClickEvent IclCancelEvent() {
        return new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/icl cancel");
    }

    public static String IclTranslate(String key, Object ... args) {
        String translation = null;
        if (translations != null) {
            translation = translations.get(key);
            LOGGER.debug("Translation: {}", (Object)translation);
        }
        if (translation == null && defaultTranslations != null) {
            translation = defaultTranslations.get(key);
            LOGGER.debug("Default Translation: {}", (Object)translation);
        }
        if (translation != null) {
            if (args != null && args.length > 0) {
                return String.format(translation, args);
            }
            return translation;
        }
        return key;
    }

    public static void IclPlaysound(ServerPlayer player, boolean isLastSound) {
        double e = player.getX();
        double f = player.getY();
        double g = player.getZ();
        double h = e * e + f * f + g * g;
        double k = Math.sqrt(h);
        Vec3 vec3d = new Vec3(player.getX() + e / k * 2.0, player.getY() + f / k * 2.0, player.getZ() + g / k * 2.0);
        ResourceLocation sound = isLastSound ? ResourceLocation.parse((String)ICLCommon.config.LastNotificationSound) : ResourceLocation.parse((String)ICLCommon.config.NotificationSound);
        Holder registryEntry = Holder.direct((Object)SoundEvent.createVariableRangeEvent((ResourceLocation)sound));
        player.connection.send((Packet)new ClientboundSoundPacket(registryEntry, SoundSource.PLAYERS, vec3d.x(), vec3d.y(), vec3d.z(), 1.0f, 1.0f, 1L), (PacketSendListener)null);
    }

    private static boolean permissionCheckforCancel(CommandSourceStack source) {
        if (permissionHandler != null) {
            return permissionHandler.hasPermission(source, "icl.cancel");
        }
        return !ICLCommon.config.RequireOpCancel || source.hasPermission(2);
    }
}

