/*
 * Decompiled with CFR 0.152.
 */
package vt.icl.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.ExecutionException;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;
import vt.icl.ICLCommon;
import vt.icl.config.Configuration;
import vt.icl.config.lang.IclTranslationManager;

public class IclCommand {
    private static final SuggestionProvider<CommandSourceStack> CONFIG_FIELDS = (context, builder) -> {
        Configuration config = ICLCommon.config;
        config.get().forEach((key, type) -> builder.suggest(key));
        return builder.buildFuture();
    };
    private static final SuggestionProvider<CommandSourceStack> LANGUAGES = (context, builder) -> {
        IclTranslationManager.getAvailableLangs().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    };
    private static final SuggestionProvider<CommandSourceStack> SOUNDS = (context, builder) -> {
        try {
            ((Suggestions)SuggestionProviders.AVAILABLE_SOUNDS.getSuggestions(context, builder).get()).getList().forEach(suggestion -> {
                String sound = suggestion.getText();
                String[] split = sound.split(":");
                builder.suggest(split[split.length - 1]);
            });
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        return builder.buildFuture();
    };
    private static final SuggestionProvider<CommandSourceStack> COLORS = (context, builder) -> {
        builder.suggest("BLACK");
        builder.suggest("DARK_BLUE");
        builder.suggest("DARK_GREEN");
        builder.suggest("DARK_AQUA");
        builder.suggest("DARK_RED");
        builder.suggest("DARK_PURPLE");
        builder.suggest("GOLD");
        builder.suggest("GRAY");
        builder.suggest("DARK_GRAY");
        builder.suggest("BLUE");
        builder.suggest("GREEN");
        builder.suggest("AQUA");
        builder.suggest("RED");
        builder.suggest("LIGHT_PURPLE");
        builder.suggest("YELLOW");
        builder.suggest("WHITE");
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandRegistryAccess, Commands.CommandSelection registrationEnvironment) {
        IclCommand.register(dispatcher);
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"icl").executes(context -> {
            IclCommand.showReadmeInfo(((CommandSourceStack)context.getSource()).getPlayer());
            return 1;
        })).then(((LiteralArgumentBuilder)Commands.literal((String)"forceclean").requires(source -> IclCommand.permissionCheck(source, "forceclean"))).executes(context -> {
            IclCommand.forceClean(((CommandSourceStack)context.getSource()).getServer(), ((CommandSourceStack)context.getSource()).getPlayer());
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(source -> IclCommand.permissionCheck(source, "reload"))).executes(context -> {
            IclCommand.reloadIcl(((CommandSourceStack)context.getSource()).getPlayer());
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"cancel").requires(source -> IclCommand.permissionCheckforCancel(source))).executes(context -> {
            IclCommand.cancelClean(((CommandSourceStack)context.getSource()).getPlayer(), 0);
            return 1;
        })).then(Commands.argument((String)"seconds", (ArgumentType)IntegerArgumentType.integer()).suggests((context, suggestionsBuilder) -> suggestionsBuilder.suggest("300").buildFuture()).executes(context -> {
            IclCommand.cancelClean(((CommandSourceStack)context.getSource()).getPlayer(), IntegerArgumentType.getInteger((CommandContext)context, (String)"seconds"));
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"config").requires(source -> IclCommand.permissionCheck(source, "config"))).then(Commands.literal((String)"set").then(((RequiredArgumentBuilder)Commands.argument((String)"key", (ArgumentType)StringArgumentType.string()).suggests(CONFIG_FIELDS).executes(context -> {
            String key = StringArgumentType.getString((CommandContext)context, (String)"key");
            IclCommand.showConfigValue(key, ((CommandSourceStack)context.getSource()).getPlayer());
            return 1;
        })).then(Commands.argument((String)"value", (ArgumentType)StringArgumentType.string()).suggests((context, suggestionsBuilder) -> switch (StringArgumentType.getString((CommandContext)context, (String)"key")) {
            case "Delay" -> suggestionsBuilder.suggest("80").buildFuture();
            case "NotificationDelay" -> suggestionsBuilder.suggest("15").buildFuture();
            case "NotificationStart" -> suggestionsBuilder.suggest("60").buildFuture();
            case "NotificationTimes" -> suggestionsBuilder.suggest("4").buildFuture();
            case "CountdownStart" -> suggestionsBuilder.suggest("5").buildFuture();
            case "doNotificationCountdown", "doShowNotification", "doNotificationSound", "doLastNotificationSound", "RequireOp", "RequireOpCancel", "preserveNoDespawnItems", "preserveNoPickupItems", "UsePermissionsApi" -> suggestionsBuilder.suggest("true").suggest("false").buildFuture();
            case "NotificationSound", "LastNotificationSound" -> SOUNDS.getSuggestions(context, suggestionsBuilder);
            case "NotificationLang" -> LANGUAGES.getSuggestions(context, suggestionsBuilder);
            case "NotificationColor" -> COLORS.getSuggestions(context, suggestionsBuilder);
            default -> suggestionsBuilder.buildFuture();
        }).executes(context -> {
            String key = StringArgumentType.getString((CommandContext)context, (String)"key");
            String value = StringArgumentType.getString((CommandContext)context, (String)"value");
            IclCommand.ConfigEdit(key, value, ((CommandSourceStack)context.getSource()).getPlayer());
            return 1;
        }))))));
    }

    private static boolean permissionCheck(CommandSourceStack source, String permission) {
        if (ICLCommon.permissionHandler != null) {
            return ICLCommon.permissionHandler.hasPermission(source, "icl." + permission);
        }
        return !ICLCommon.config.RequireOp || source.hasPermission(2);
    }

    private static boolean permissionCheckforCancel(CommandSourceStack source) {
        if (ICLCommon.permissionHandler != null) {
            return ICLCommon.permissionHandler.hasPermission(source, "icl.cancel");
        }
        return !ICLCommon.config.RequireOpCancel || source.hasPermission(2);
    }

    public static void showReadmeInfo(@Nullable ServerPlayer player) {
        if (player != null) {
            player.sendSystemMessage((Component)Component.literal((String)(ICLCommon.MOD_PREFIX + ICLCommon.IclTranslate("text.icl.readme", new Object[0]))).withStyle(ChatFormatting.GREEN));
        } else {
            ICLCommon.LOGGER.info(ICLCommon.IclTranslate("text.icl.readme", new Object[0]));
        }
    }

    public static void showConfigValue(String key, @Nullable ServerPlayer player) {
        String currentValue = ICLCommon.config.getValue(key);
        String defaultValue = new Configuration().getValue(key);
        if (player != null) {
            player.sendSystemMessage((Component)Component.literal((String)(ICLCommon.MOD_PREFIX + ICLCommon.IclTranslate("text.icl.config.current", key, currentValue, defaultValue))).withStyle(ChatFormatting.GREEN));
        } else {
            ICLCommon.LOGGER.info("Current value of {} is {}", (Object)key, (Object)currentValue);
            ICLCommon.LOGGER.info("Default value of {} is {}", (Object)key, (Object)defaultValue);
        }
    }

    public static void reloadIcl(@Nullable ServerPlayer player) {
        try {
            ICLCommon.reloadIcl();
            if (player != null) {
                player.sendSystemMessage((Component)Component.literal((String)(ICLCommon.MOD_PREFIX + ICLCommon.IclTranslate("text.icl.reload", new Object[0]))).withStyle(ChatFormatting.GREEN));
            }
        }
        catch (Exception e) {
            if (player != null) {
                player.sendSystemMessage((Component)Component.literal((String)(ICLCommon.MOD_PREFIX + ICLCommon.IclTranslate("text.icl.reload.fail", new Object[0]))).withStyle(ChatFormatting.RED));
                player.sendSystemMessage((Component)Component.literal((String)(ICLCommon.MOD_PREFIX + e.getMessage())).withStyle(ChatFormatting.RED));
            }
            ICLCommon.LOGGER.error(e.getMessage());
        }
    }

    public static void cancelClean(@Nullable ServerPlayer player, int seconds) {
        try {
            if (seconds < 0) {
                seconds = 0;
            }
            ICLCommon.CancelIcl(seconds);
            if (player != null) {
                player.sendSystemMessage((Component)Component.literal((String)(ICLCommon.MOD_PREFIX + ICLCommon.IclTranslate("text.icl.cancel.message", new Object[0]))).withStyle(ChatFormatting.GREEN));
            }
        }
        catch (Exception e) {
            if (player != null) {
                player.sendSystemMessage((Component)Component.literal((String)(ICLCommon.MOD_PREFIX + ICLCommon.IclTranslate("text.icl.reload.fail", new Object[0]))).withStyle(ChatFormatting.RED));
                player.sendSystemMessage((Component)Component.literal((String)(ICLCommon.MOD_PREFIX + e.getMessage())).withStyle(ChatFormatting.RED));
            }
            ICLCommon.LOGGER.error(e.getMessage());
        }
    }

    public static void forceClean(MinecraftServer server, @Nullable ServerPlayer player) {
        server.execute(() -> ICLCommon.clearItems(server));
        if (player != null) {
            player.sendSystemMessage((Component)Component.literal((String)(ICLCommon.MOD_PREFIX + ICLCommon.IclTranslate("text.icl.forceclear", new Object[0]))).withStyle(ChatFormatting.GREEN));
        }
    }

    public static void ConfigEdit(String key, String value, @Nullable ServerPlayer player) {
        block6: {
            ICLCommon.config.set(key, value);
            if (key.equals("NotificationLang")) {
                ICLCommon.translations = IclTranslationManager.loadTranslation(value);
            }
            if (key.equals("NotificationColor") && value != null) {
                try {
                    if (player != null) {
                        player.sendSystemMessage((Component)Component.literal((String)(ICLCommon.MOD_PREFIX + ICLCommon.IclTranslate("text.icl.config.updated", key, value))).withStyle(ChatFormatting.valueOf((String)ICLCommon.config.NotificationColor)));
                        return;
                    }
                }
                catch (IllegalArgumentException e) {
                    if (player == null) break block6;
                    player.sendSystemMessage((Component)Component.literal((String)(ICLCommon.MOD_PREFIX + ICLCommon.IclTranslate("text.icl.config.updated", key, value))).withStyle(ChatFormatting.RED));
                    return;
                }
            }
        }
        if (player != null) {
            player.sendSystemMessage((Component)Component.literal((String)(ICLCommon.MOD_PREFIX + ICLCommon.IclTranslate("text.icl.config.updated", key, value))).withStyle(ChatFormatting.GREEN));
        }
        ICLCommon.reloadIcl();
    }
}

