/*
 * Decompiled with CFR 0.152.
 */
package vt.icl.config.lang;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import vt.icl.ICLCommon;

public class IclTranslationManager {
    static File langDir = ICLCommon.CONFIG_DIR.resolve("lang/").toFile();
    private static final String LANG_FILE_NAME = "%s.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Type MAP_TYPE = new TypeToken<Map<String, String>>(){}.getType();

    public static List<String> getAvailableLangs() {
        String[] files = langDir.list((dir, name) -> name.endsWith(".json"));
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                files[i] = files[i].substring(0, files[i].length() - 5);
            }
            return List.of(files);
        }
        return List.of();
    }

    public static Map<String, String> loadTranslation(String lang) {
        File langFile = langDir.toPath().resolve(String.format(LANG_FILE_NAME, lang)).toFile();
        if (langFile.exists()) {
            try {
                String json = FileUtils.readFileToString((File)langFile, (String)"UTF-8");
                Map loadedTranslations = (Map)GSON.fromJson(json, MAP_TYPE);
                Map<String, String> defaultTranslations = IclTranslationManager.getDefaultEnUsTranslations();
                for (String key : defaultTranslations.keySet()) {
                    if (loadedTranslations.containsKey(key)) continue;
                    if (Objects.equals(lang, "ru_ru")) {
                        defaultTranslations = IclTranslationManager.getDefaultRuRuTranslations();
                    }
                    loadedTranslations.put(key, defaultTranslations.get(key));
                    ICLCommon.LOGGER.info("Warning: Missing translation for key '" + key + "' in " + lang + ". Using default translation.");
                }
                IclTranslationManager.saveTranslation(lang, loadedTranslations);
                return loadedTranslations;
            }
            catch (IOException e) {
                ICLCommon.LOGGER.info("Failed to load translation file for " + lang);
                ICLCommon.LOGGER.info(e.getMessage());
            }
        } else {
            ICLCommon.LOGGER.info("Translation file for " + lang + " not found. Using default translations.");
            return IclTranslationManager.getDefaultEnUsTranslations();
        }
        return null;
    }

    public static void saveTranslation(String lang, Map<String, String> translations) {
        File langFile = langDir.toPath().resolve(String.format(LANG_FILE_NAME, lang)).toFile();
        try {
            String json = GSON.toJson(translations, MAP_TYPE);
            FileUtils.writeStringToFile((File)langFile, (String)json, (String)"UTF-8");
        }
        catch (IOException e) {
            ICLCommon.LOGGER.info("Failed to save translation file for " + lang + ": " + e.getMessage());
        }
    }

    public static void createDefaultTranslationFiles() {
        IclTranslationManager.createDefaultTranslationFile("en_us", IclTranslationManager.getDefaultEnUsTranslations());
        IclTranslationManager.createDefaultTranslationFile("ru_ru", IclTranslationManager.getDefaultRuRuTranslations());
        IclTranslationManager.createDefaultTranslationFile("zh_cn", IclTranslationManager.getDefaultZhCnTranslations());
    }

    private static void createDefaultTranslationFile(String lang, Map<String, String> defaultTranslations) {
        File langFile = langDir.toPath().resolve(String.format(LANG_FILE_NAME, lang)).toFile();
        if (!langFile.exists()) {
            IclTranslationManager.saveTranslation(lang, defaultTranslations);
        }
    }

    private static Map<String, String> getDefaultEnUsTranslations() {
        HashMap<String, String> translations = new HashMap<String, String>();
        translations.put("text.icl.notification", "Items on the ground will be removed in %d seconds");
        translations.put("text.icl.countdown", "Clearing items in %d");
        translations.put("text.icl.clear", "Clearing items");
        translations.put("text.icl.forceclear", "Forced clearing of items");
        translations.put("text.icl.config.updated", "Config value %s changed to %s");
        translations.put("text.icl.reload", "ICL reloaded");
        translations.put("text.icl.cancel.button", "[Cancel]");
        translations.put("text.icl.cancel.message", "Item clear cancelled");
        translations.put("text.icl.reload.fail", "Failed to reload ICL");
        translations.put("text.icl.clear.finish", "Items cleared: %d");
        translations.put("text.icl.config.current", "Current value of %s: %s (Default: %s)");
        translations.put("text.icl.readme", "\u00a7l\u00a7nCommands\u00a7r\n\nThe main command provided by ICL is \u00a7a/icl\u00a7r, which has several subcommands:\n\n- \u00a7a/icl forceclean\u00a7r: Immediately clears all items on the ground.\n- \u00a7a/icl reload\u00a7r: Reloads the ICL.\n- \u00a7a/icl config set <key> <value>\u00a7r: Changes a configuration value. To see current configuration value, use /icl config set <key>.\n- \u00a7a/icl cancel [seconds]\u00a7r: Cancels the next clear. If a number of seconds is provided, the next clear will be scheduled after that many seconds.\n\n\u00a7l\u00a7nConfiguration\u00a7r\n\nConfiguration values can be changed using the \u00a7a/icl config set\u00a7r command. Here are some of the configurable values:\n\n- \u00a7aDelay\u00a7r: The delay (in seconds) between automatic item clears.\n- \u00a7aNotificationDelay\u00a7r: The delay (in seconds) before a clear when a notification will be sent.\n- \u00a7aNotificationStart\u00a7r: The time (in seconds) when notifications start being sent before a clear.\n- \u00a7aNotificationTimes\u00a7r: The number of notifications to send before a clear.\n- \u00a7aCountdownStart\u00a7r: The time (in seconds) when the countdown starts before a clear.\n- \u00a7adoNotificationCountdown\u00a7r: Whether to show a countdown before a clear.\n- \u00a7adoNotificationSound\u00a7r: Whether to play a sound when a notification is sent.\n- \u00a7adoLastNotificationSound\u00a7r: Whether to play a sound when a last notification is sent.\n- \u00a7aNotificationSound\u00a7r: The sound to play when a notification is sent.\n- \u00a7aLastNotificationSound\u00a7r: The sound to play when a last notification is sent.\n- \u00a7aNotificationLang\u00a7r: The language for notifications.\n- \u00a7aNotificationColor\u00a7r: The color for notifications.\n- \u00a7aRequireOp\u00a7r: Whether to require OP to use ICL commands(except /icl, /icl cancel).\n- \u00a7aRequireOpCancel\u00a7r: Whether to require OP to cancel a clear.\n- \u00a7apreserveNoDespawnItems\u00a7r: Whether to preserve items that are set to never despawn.\n- \u00a7apreserveNoPickupItems\u00a7r: Whether to preserve items that are set to never be picked up.");
        return translations;
    }

    private static Map<String, String> getDefaultRuRuTranslations() {
        HashMap<String, String> translations = new HashMap<String, String>();
        translations.put("text.icl.notification", "\u041f\u0440\u0435\u0434\u043c\u0435\u0442\u044b \u043d\u0430 \u043f\u043e\u043b\u0443 \u0431\u0443\u0434\u0443\u0442 \u0443\u0434\u0430\u043b\u0435\u043d\u044b \u0447\u0435\u0440\u0435\u0437 %d \u0441\u0435\u043a\u0443\u043d\u0434");
        translations.put("text.icl.countdown", "\u041e\u0447\u0438\u0441\u0442\u043a\u0430 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u043e\u0432 \u0447\u0435\u0440\u0435\u0437 %d");
        translations.put("text.icl.clear", "\u041e\u0447\u0438\u0441\u0442\u043a\u0430 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u043e\u0432");
        translations.put("text.icl.forceclear", "\u041f\u0440\u0438\u043d\u0443\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u043e\u0447\u0438\u0441\u0442\u043a\u0430 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u043e\u0432");
        translations.put("text.icl.config.updated", "\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0430 %s \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e \u043d\u0430 %s");
        translations.put("text.icl.reload", "ICL \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d");
        translations.put("text.icl.cancel.button", "[\u041e\u0442\u043c\u0435\u043d\u0430]");
        translations.put("text.icl.cancel.message", "\u041e\u0447\u0438\u0441\u0442\u043a\u0430 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u043e\u0432 \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430");
        translations.put("text.icl.reload.fail", "ICL \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c");
        translations.put("text.icl.clear.finish", "\u041e\u0447\u0438\u0449\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u043e\u0432: %d");
        translations.put("text.icl.config.current", "\u0422\u0435\u043a\u0443\u0449\u0435\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 %s: %s (\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e: %s)");
        translations.put("text.icl.readme", "\u00a7l\u00a7n\u041a\u043e\u043c\u0430\u043d\u0434\u044b\u00a7r\n\n\u041e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u0430, \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u043c\u0430\u044f ICL, - \u00a7a/icl\u00a7r, \u0443 \u043a\u043e\u0442\u043e\u0440\u043e\u0439 \u0435\u0441\u0442\u044c \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u0434\u043a\u043e\u043c\u0430\u043d\u0434:\n\n- \u00a7a/icl forceclean\u00a7r: \u041d\u0435\u043c\u0435\u0434\u043b\u0435\u043d\u043d\u043e \u043e\u0447\u0438\u0449\u0430\u0435\u0442 \u0432\u0441\u0435 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u044b \u043d\u0430 \u043f\u043e\u043b\u0443.\n- \u00a7a/icl reload\u00a7r: \u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0430\u0435\u0442 ICL.\n- \u00a7a/icl config set <key> <value>\u00a7r: \u0418\u0437\u043c\u0435\u043d\u044f\u0435\u0442 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438. \u0427\u0442\u043e\u0431\u044b \u0443\u0432\u0438\u0434\u0435\u0442\u044c \u0442\u0435\u043a\u0443\u0449\u0435\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 /icl config set <key>.\n- \u00a7a/icl cancel [seconds]\u00a7r: \u041e\u0442\u043c\u0435\u043d\u044f\u0435\u0442 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0443\u044e \u043e\u0447\u0438\u0441\u0442\u043a\u0443. \u0415\u0441\u043b\u0438 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0441\u0435\u043a\u0443\u043d\u0434, \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0430\u044f \u043e\u0447\u0438\u0441\u0442\u043a\u0430 \u0431\u0443\u0434\u0435\u0442 \u0437\u0430\u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0430 \u0447\u0435\u0440\u0435\u0437 \u0441\u0442\u043e\u043b\u044c\u043a\u043e \u0441\u0435\u043a\u0443\u043d\u0434.\n\n\u00a7l\u00a7n\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f\u00a7r\n\n\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043c\u043e\u0436\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e \u043a\u043e\u043c\u0430\u043d\u0434\u044b \u00a7a/icl config set\u00a7r. \u0412\u043e\u0442 \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0438\u0437 \u043d\u0430\u0441\u0442\u0440\u0430\u0438\u0432\u0430\u0435\u043c\u044b\u0445 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439:\n\n- \u00a7aDelay\u00a7r: \u0417\u0430\u0434\u0435\u0440\u0436\u043a\u0430 (\u0432 \u0441\u0435\u043a\u0443\u043d\u0434\u0430\u0445) \u043c\u0435\u0436\u0434\u0443 \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u043c\u0438 \u043e\u0447\u0438\u0441\u0442\u043a\u0430\u043c\u0438 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u043e\u0432.\n- \u00a7aNotificationDelay\u00a7r: \u0417\u0430\u0434\u0435\u0440\u0436\u043a\u0430 (\u0432 \u0441\u0435\u043a\u0443\u043d\u0434\u0430\u0445) \u043f\u0435\u0440\u0435\u0434 \u043e\u0447\u0438\u0441\u0442\u043a\u043e\u0439, \u043a\u043e\u0433\u0434\u0430 \u0431\u0443\u0434\u0435\u0442 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435.\n- \u00a7aNotificationStart\u00a7r: \u0412\u0440\u0435\u043c\u044f (\u0432 \u0441\u0435\u043a\u0443\u043d\u0434\u0430\u0445), \u043a\u043e\u0433\u0434\u0430 \u043d\u0430\u0447\u043d\u0443\u0442 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0442\u044c\u0441\u044f \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0435\u0434 \u043e\u0447\u0438\u0441\u0442\u043a\u043e\u0439.\n- \u00a7aNotificationTimes\u00a7r: \u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0439, \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c\u044b\u0445 \u043f\u0435\u0440\u0435\u0434 \u043e\u0447\u0438\u0441\u0442\u043a\u043e\u0439.\n- \u00a7aCountdownStart\u00a7r: \u0412\u0440\u0435\u043c\u044f (\u0432 \u0441\u0435\u043a\u0443\u043d\u0434\u0430\u0445), \u043a\u043e\u0433\u0434\u0430 \u043d\u0430\u0447\u043d\u0435\u0442\u0441\u044f \u043e\u0431\u0440\u0430\u0442\u043d\u044b\u0439 \u043e\u0442\u0441\u0447\u0435\u0442 \u043f\u0435\u0440\u0435\u0434 \u043e\u0447\u0438\u0441\u0442\u043a\u043e\u0439.\n- \u00a7adoNotificationCountdown\u00a7r: \u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u043b\u0438 \u043e\u0431\u0440\u0430\u0442\u043d\u044b\u0439 \u043e\u0442\u0441\u0447\u0435\u0442 \u043f\u0435\u0440\u0435\u0434 \u043e\u0447\u0438\u0441\u0442\u043a\u043e\u0439.\n- \u00a7adoNotificationSound\u00a7r: \u0412\u043e\u0441\u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u044c \u043b\u0438 \u0437\u0432\u0443\u043a \u043f\u0440\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0435 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f.\n- \u00a7adoLastNotificationSound\u00a7r: \u0412\u043e\u0441\u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u044c \u043b\u0438 \u0437\u0432\u0443\u043a \u043f\u0440\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0435 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0433\u043e \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f.\n- \u00a7aNotificationSound\u00a7r: \u0417\u0432\u0443\u043a, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0432\u043e\u0441\u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0441\u044f \u043f\u0440\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0435 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f.\n- \u00a7aLastNotificationSound\u00a7r: \u0417\u0432\u0443\u043a, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0432\u043e\u0441\u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0441\u044f \u043f\u0440\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0435 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0433\u043e \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f.\n- \u00a7aNotificationLang\u00a7r: \u042f\u0437\u044b\u043a \u0434\u043b\u044f \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0439.\n- \u00a7aNotificationColor\u00a7r: \u0426\u0432\u0435\u0442 \u0434\u043b\u044f \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0439.\n- \u00a7aRequireOp\u00a7r: \u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043b\u0438 OP \u0434\u043b\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u043a\u043e\u043c\u0430\u043d\u0434 ICL (\u043a\u0440\u043e\u043c\u0435 /icl, /icl cancel).\n- \u00a7aRequireOpCancel\u00a7r: \u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043b\u0438 OP \u0434\u043b\u044f \u043e\u0442\u043c\u0435\u043d\u044b \u043e\u0447\u0438\u0441\u0442\u043a\u0438.\n- \u00a7apreserveNoDespawnItems\u00a7r: \u0421\u043b\u0435\u0434\u0443\u0435\u0442 \u043b\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u044f\u0442\u044c \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u044b, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043d\u0438\u043a\u043e\u0433\u0434\u0430 \u043d\u0435 \u0438\u0441\u0447\u0435\u0437\u043d\u0443\u0442.\n- \u00a7apreserveNoPickupItems\u00a7r: \u0421\u043b\u0435\u0434\u0443\u0435\u0442 \u043b\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u044f\u0442\u044c \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u044b, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043d\u0435\u043b\u044c\u0437\u044f \u043f\u043e\u0434\u043e\u0431\u0440\u0430\u0442\u044c.");
        return translations;
    }

    private static Map<String, String> getDefaultZhCnTranslations() {
        HashMap<String, String> translations = new HashMap<String, String>();
        translations.put("text.icl.notification", "\u6389\u843d\u7269\u5c06\u5728 %d \u79d2\u540e\u6e05\u9664");
        translations.put("text.icl.countdown", "\u6389\u843d\u7269\u6e05\u9664\u5012\u8ba1\u65f6 %d \u79d2");
        translations.put("text.icl.clear", "\u6e05\u9664\u4e86\u6389\u843d\u7269");
        translations.put("text.icl.forceclear", "\u5f3a\u5236\u6e05\u9664\u4e86\u6389\u843d\u7269");
        translations.put("text.icl.config.updated", "\u8bbe\u5b9a\u503c %s \u6539\u53d8\u4e3a %s");
        translations.put("text.icl.reload", "ICL \u91cd\u542f\u5b8c\u6bd5");
        translations.put("text.icl.cancel.button", "[\u53d6\u6d88]");
        translations.put("text.icl.cancel.message", "\u5df2\u53d6\u6d88\u6389\u843d\u7269\u6e05\u9664");
        translations.put("text.icl.reload.fail", "ICL \u91cd\u542f\u5931\u8d25");
        translations.put("text.icl.clear.finish", "\u6e05\u9664\u6389\u843d\u7269\u6570\u76ee: %d");
        translations.put("text.icl.config.current", "%s \u7684\u5f53\u524d\u503c\u4e3a: %s (\u9ed8\u8ba4\u4e3a: %s)");
        translations.put("text.icl.readme", "\u00a7l\u00a7n\u547d\u4ee4\u00a7r\n\nICL \u63d0\u4f9b\u7684\u4e3b\u8981\u547d\u4ee4\u662f \u00a7a/icl\u00a7r\uff0c\u5b83\u6709\u51e0\u4e2a\u5b50\u547d\u4ee4\uff1a\n\n- \u00a7a/icl forceclean\u00a7r: \u7acb\u5373\u6e05\u9664\u5730\u9762\u4e0a\u7684\u6240\u6709\u7269\u54c1\u3002\n- \u00a7a/icl reload\u00a7r: \u91cd\u65b0\u52a0\u8f7d ICL\u3002\n- \u00a7a/icl config set <key> <value>\u00a7r: \u66f4\u6539\u914d\u7f6e\u503c\u3002\u8981\u67e5\u770b\u5f53\u524d\u914d\u7f6e\u503c\uff0c\u4f7f\u7528 /icl config set <key>\u3002\n- \u00a7a/icl cancel [seconds]\u00a7r: \u53d6\u6d88\u4e0b\u6b21\u6e05\u9664\u3002\u5982\u679c\u63d0\u4f9b\u4e86\u79d2\u6570\uff0c\u4e0b\u6b21\u6e05\u9664\u5c06\u5728\u8be5\u79d2\u6570\u540e\u5b89\u6392\u3002\n\n\u00a7l\u00a7n\u914d\u7f6e\u00a7r\n\n\u914d\u7f6e\u503c\u53ef\u4ee5\u4f7f\u7528 \u00a7a/icl config set\u00a7r \u547d\u4ee4\u8fdb\u884c\u66f4\u6539\u3002\u4ee5\u4e0b\u662f\u4e00\u4e9b\u53ef\u914d\u7f6e\u7684\u503c\uff1a\n\n- \u00a7aDelay\u00a7r: \u81ea\u52a8\u6e05\u9664\u7269\u54c1\u4e4b\u95f4\u7684\u5ef6\u8fdf\uff08\u4ee5\u79d2\u4e3a\u5355\u4f4d\uff09\u3002\n- \u00a7aNotificationDelay\u00a7r: \u5728\u6e05\u9664\u524d\uff0c\u53d1\u9001\u901a\u77e5\u7684\u5ef6\u8fdf\u65f6\u95f4\uff08\u4ee5\u79d2\u4e3a\u5355\u4f4d\uff09\u3002\n- \u00a7aNotificationStart\u00a7r: \u5728\u6e05\u9664\u524d\uff0c\u5f00\u59cb\u53d1\u9001\u901a\u77e5\u7684\u65f6\u95f4\uff08\u4ee5\u79d2\u4e3a\u5355\u4f4d\uff09\u3002\n- \u00a7aNotificationTimes\u00a7r: \u5728\u6e05\u9664\u524d\u53d1\u9001\u901a\u77e5\u7684\u6b21\u6570\u3002\n- \u00a7aCountdownStart\u00a7r: \u5728\u6e05\u9664\u524d\uff0c\u5012\u8ba1\u65f6\u5f00\u59cb\u7684\u65f6\u95f4\uff08\u4ee5\u79d2\u4e3a\u5355\u4f4d\uff09\u3002\n- \u00a7adoNotificationCountdown\u00a7r: \u662f\u5426\u5728\u6e05\u9664\u524d\u663e\u793a\u5012\u8ba1\u65f6\u3002\n- \u00a7adoNotificationSound\u00a7r: \u662f\u5426\u5728\u53d1\u9001\u901a\u77e5\u65f6\u64ad\u653e\u58f0\u97f3\u3002\n- \u00a7adoLastNotificationSound\u00a7r: \u662f\u5426\u5728\u53d1\u9001\u6700\u540e\u4e00\u6761\u901a\u77e5\u65f6\u64ad\u653e\u58f0\u97f3\u3002\n- \u00a7aNotificationSound\u00a7r: \u53d1\u9001\u901a\u77e5\u65f6\u64ad\u653e\u7684\u58f0\u97f3\u3002\n- \u00a7aLastNotificationSound\u00a7r: \u53d1\u9001\u6700\u540e\u4e00\u6761\u901a\u77e5\u65f6\u64ad\u653e\u7684\u58f0\u97f3\u3002\n- \u00a7aNotificationLang\u00a7r: \u901a\u77e5\u7684\u8bed\u8a00\u3002\n- \u00a7aNotificationColor\u00a7r: \u901a\u77e5\u7684\u989c\u8272\u3002\n- \u00a7aRequireOp\u00a7r: \u662f\u5426\u9700\u8981 OP \u6743\u9650\u624d\u80fd\u4f7f\u7528 ICL \u547d\u4ee4\uff08\u9664\u4e86 /icl \u548c /icl cancel\uff09\u3002\n- \u00a7aRequireOpCancel\u00a7r: \u662f\u5426\u9700\u8981 OP \u6743\u9650\u624d\u80fd\u53d6\u6d88\u6e05\u9664\u3002\n- \u00a7apreserveNoDespawnItems\u00a7r: \u662f\u5426\u4fdd\u7559\u8bbe\u4e3a\u6c38\u4e0d\u6d88\u5931\u7684\u7269\u54c1\u3002\n- \u00a7apreserveNoPickupItems\u00a7r: \u662f\u5426\u4fdd\u7559\u8bbe\u4e3a\u6c38\u4e0d\u88ab\u62fe\u53d6\u7684\u7269\u54c1\u3002");
        return translations;
    }
}

