/*
 * Decompiled with CFR 0.152.
 */
package vt.icl.neoforge.permission;

import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.server.permission.PermissionAPI;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContext;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContextKey;
import net.neoforged.neoforge.server.permission.nodes.PermissionNode;
import net.neoforged.neoforge.server.permission.nodes.PermissionTypes;
import vt.icl.ICLCommon;
import vt.icl.permission.PermissionHandler;

public class NeoForgePermissions
implements PermissionHandler {
    public static final PermissionNode<Boolean> FORCECLEAN = new PermissionNode(ResourceLocation.fromNamespaceAndPath((String)"icl", (String)"forceclean"), PermissionTypes.BOOLEAN, (player, playerUUID, context) -> false, new PermissionDynamicContextKey[0]);
    public static final PermissionNode<Boolean> RELOAD = new PermissionNode(ResourceLocation.fromNamespaceAndPath((String)"icl", (String)"reload"), PermissionTypes.BOOLEAN, (player, playerUUID, context) -> false, new PermissionDynamicContextKey[0]);
    public static final PermissionNode<Boolean> CONFIG = new PermissionNode(ResourceLocation.fromNamespaceAndPath((String)"icl", (String)"config"), PermissionTypes.BOOLEAN, (player, playerUUID, context) -> false, new PermissionDynamicContextKey[0]);
    public static final PermissionNode<Boolean> CANCEL = new PermissionNode(ResourceLocation.fromNamespaceAndPath((String)"icl", (String)"cancel"), PermissionTypes.BOOLEAN, (player, playerUUID, context) -> false, new PermissionDynamicContextKey[0]);
    public static List<PermissionNode<?>> permissionNodesList = List.of(FORCECLEAN, RELOAD, CONFIG, CANCEL);

    @Override
    public boolean hasPermission(CommandSourceStack source, String permission) {
        PermissionNode permissionNode = PermissionAPI.getRegisteredNodes().stream().filter(p -> p.getNodeName().equals(permission)).findFirst().orElse(null);
        if (source.hasPermission(4)) {
            return true;
        }
        if (source.getPlayer() == null) {
            return false;
        }
        if (permissionNode == null) {
            ICLCommon.LOGGER.warn("Permission node {} not found", (Object)permission);
            return false;
        }
        return (Boolean)PermissionAPI.getPermission((ServerPlayer)source.getPlayer(), (PermissionNode)permissionNode, (PermissionDynamicContext[])new PermissionDynamicContext[0]);
    }

    public static void init() {
        FORCECLEAN.setInformation(Component.nullToEmpty((String)"Force Clean"), Component.nullToEmpty((String)"Allows the player to force clean the world"));
        RELOAD.setInformation(Component.nullToEmpty((String)"Reload"), Component.nullToEmpty((String)"Allows the player to reload the config"));
        CONFIG.setInformation(Component.nullToEmpty((String)"Config"), Component.nullToEmpty((String)"Allows the player to view the config"));
        CANCEL.setInformation(Component.nullToEmpty((String)"Cancel"), Component.nullToEmpty((String)"Allows the player to cancel the current operation"));
    }
}

