/*
 * Decompiled with CFR 0.152.
 */
package tfar.craftingstation.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import tfar.craftingstation.block.CraftingStationBlock;
import tfar.craftingstation.blockentity.CraftingStationBlockEntity;
import tfar.craftingstation.platform.Services;

public class CraftingStationSlabBlock
extends SlabBlock
implements EntityBlock {
    public CraftingStationSlabBlock(BlockBehaviour.Properties properties) {
        super(properties);
        ((BlockState)this.stateDefinition.any()).setValue((Property)CraftingStationBlock.FACING, (Comparable)Direction.NORTH);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult pHitResult) {
        MenuProvider iNamedContainerProvider;
        if (!level.isClientSide && (iNamedContainerProvider = this.getMenuProvider(state, level, pos)) != null) {
            Services.PLATFORM.openMenu((ServerPlayer)player, iNamedContainerProvider, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public MenuProvider getMenuProvider(BlockState state, Level world, BlockPos pos) {
        BlockEntity te = world.getBlockEntity(pos);
        return te instanceof CraftingStationBlockEntity ? (MenuProvider)te : null;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return Services.PLATFORM.create(pPos, pState);
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity tileentity = worldIn.getBlockEntity(pos);
            if (tileentity instanceof CraftingStationBlockEntity) {
                CraftingStationBlockEntity craftingStationBlock = (CraftingStationBlockEntity)tileentity;
                CraftingStationBlock.dropItems(craftingStationBlock.input, worldIn, pos);
                worldIn.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, worldIn, pos, newState, isMoving);
        }
    }

    public BlockState rotate(BlockState p_185499_1_, Rotation p_185499_2_) {
        return (BlockState)p_185499_1_.setValue((Property)CraftingStationBlock.FACING, (Comparable)p_185499_2_.rotate((Direction)p_185499_1_.getValue((Property)CraftingStationBlock.FACING)));
    }

    public BlockState mirror(BlockState p_185471_1_, Mirror p_185471_2_) {
        return p_185471_1_.rotate(p_185471_2_.getRotation((Direction)p_185471_1_.getValue((Property)CraftingStationBlock.FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        super.createBlockStateDefinition(p_206840_1_);
        p_206840_1_.add(new Property[]{CraftingStationBlock.FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_196258_1_) {
        return (BlockState)super.getStateForPlacement(p_196258_1_).setValue((Property)CraftingStationBlock.FACING, (Comparable)p_196258_1_.getHorizontalDirection());
    }
}

