/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.base.multiblock.part.io;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.base.multiblock.part.AbstractMultiblockEntity;
import it.zerono.mods.zerocore.lib.data.capability.BlockCapabilitySource;
import it.zerono.mods.zerocore.lib.multiblock.AbstractMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockPart;
import java.util.function.BooleanSupplier;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.jetbrains.annotations.Nullable;

public class IOPortBlockCapabilitySource<Controller extends AbstractCuboidMultiblockController<Controller>, Port extends AbstractMultiblockEntity<Controller>, Capability>
extends BlockCapabilitySource<Capability, Direction> {
    private final Port _ioPort;

    public IOPortBlockCapabilitySource(Port ioPort, BlockCapability<Capability, @Nullable Direction> capability) {
        super(capability);
        Preconditions.checkNotNull(ioPort, (Object)"IO entity must not be null");
        this._ioPort = ioPort;
    }

    public IOPortBlockCapabilitySource(Port ioPort, BlockCapability<Capability, @Nullable Direction> capability, BooleanSupplier isCacheValidSupplier, Runnable capabilityInvalidationListener) {
        super(capability, isCacheValidSupplier, capabilityInvalidationListener);
        Preconditions.checkNotNull(ioPort, (Object)"IO entity must not be null");
        this._ioPort = ioPort;
    }

    public void onPortChanged() {
        ((AbstractCuboidMultiblockPart)this._ioPort).getOutwardDirection().ifPresent(this::updateRemoteCapabilitySource);
    }

    private void updateRemoteCapabilitySource(Direction approachDirection) {
        Level level = this._ioPort.getCurrentWorld();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            this.setSource(level2, ((AbstractMultiblockPart)this._ioPort).getWorldPosition().relative(approachDirection), approachDirection.getOpposite());
        }
    }
}

