/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib;

import it.zerono.mods.zerocore.lib.IDebugMessages;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;

public final class DebuggableHelper {
    public static void getDebugMessagesFor(IDebugMessages messages, ItemStack stack) {
        if (stack.isEmpty()) {
            messages.addUnlocalized("ItemStack: EMPTY");
        } else {
            messages.add((Component)Component.literal((String)"ItemStack: [").append(stack.getHoverName()).append("] ").append(Integer.toString(stack.getCount())).append(" / ").append(Integer.toString(stack.getMaxStackSize())));
        }
    }

    public static void getDebugMessagesFor(IDebugMessages messages, FluidStack stack) {
        if (stack.isEmpty()) {
            messages.addUnlocalized("FluidStack: EMPTY");
        } else {
            messages.add((Component)Component.literal((String)"FluidStack: [").append(stack.getHoverName()).append("] ").append(Integer.toString(stack.getAmount())));
        }
    }

    public static void getDebugMessagesFor(IDebugMessages messages, IItemHandler handler) {
        int slots = handler.getSlots();
        messages.addUnlocalized("Slots count: %1$d", slots);
        for (int i = 0; i < slots; ++i) {
            messages.add(handler.getStackInSlot(i), DebuggableHelper::getDebugMessagesFor, (Component)Component.literal((String)String.format("[%d]", i)));
        }
    }

    public static void getDebugMessagesFor(IDebugMessages messages, IFluidHandler handler) {
        int tanks = handler.getTanks();
        messages.addUnlocalized("Tanks count: %1$d", tanks);
        for (int i = 0; i < tanks; ++i) {
            messages.add(handler.getFluidInTank(i), DebuggableHelper::getDebugMessagesFor, (Component)Component.literal((String)String.format("[%d]", i)));
        }
    }
}

