/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen.provider.client.atlas;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.zerono.mods.zerocore.lib.data.ResourceLocationBuilder;
import it.zerono.mods.zerocore.lib.datagen.provider.AbstractCodecDataProvider;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.SpriteSources;
import net.minecraft.client.renderer.texture.atlas.sources.DirectoryLister;
import net.minecraft.client.renderer.texture.atlas.sources.SingleFile;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public abstract class AtlasSpriteSourcesDataProvider
extends AbstractCodecDataProvider<List<SpriteSource>> {
    protected static final ResourceLocation ATLAS_BANNER_PATTERNS = ResourceLocation.parse((String)"banner_patterns");
    protected static final ResourceLocation ATLAS_BEDS = ResourceLocation.parse((String)"beds");
    protected static final ResourceLocation ATLAS_BLOCKS = ResourceLocation.parse((String)"blocks");
    protected static final ResourceLocation ATLAS_CHESTS = ResourceLocation.parse((String)"chests");
    protected static final ResourceLocation ATLAS_MOB_EFFECTS = ResourceLocation.parse((String)"mob_effects");
    protected static final ResourceLocation ATLAS_SHIELD_PATTERNS = ResourceLocation.parse((String)"shield_patterns");
    protected static final ResourceLocation ATLAS_SHULKER_BOXES = ResourceLocation.parse((String)"shulker_boxes");
    protected static final ResourceLocation ATLAS_SIGNS = ResourceLocation.parse((String)"signs");
    protected static final ResourceLocation ATLAS_PAINTINGS = ResourceLocation.parse((String)"paintings");
    protected static final ResourceLocation ATLAS_PARTICLES = ResourceLocation.parse((String)"particles");
    private final Map<ResourceLocation, AtlasSpriteSources> _atlases = new Object2ObjectArrayMap(16);

    protected AtlasSpriteSourcesDataProvider(String name, PackOutput output, CompletableFuture<HolderLookup.Provider> registryLookup, ResourceLocationBuilder modLocationRoot) {
        super(name, output, PackOutput.Target.RESOURCE_PACK, "atlases", registryLookup, modLocationRoot, SpriteSources.FILE_CODEC);
    }

    protected final AtlasSpriteSources atlas(ResourceLocation atlas) {
        Preconditions.checkNotNull((Object)atlas, (Object)"Atlas must not be null");
        return this._atlases.computeIfAbsent(atlas, $ -> new AtlasSpriteSources());
    }

    @Override
    protected void processData(BiConsumer<@NotNull ResourceLocation, @NotNull List<SpriteSource>> consumer) {
        this._atlases.forEach((id, sources) -> consumer.accept((ResourceLocation)id, sources._sources));
    }

    protected static final class AtlasSpriteSources {
        private final List<SpriteSource> _sources = new ObjectArrayList(16);

        private AtlasSpriteSources() {
        }

        public AtlasSpriteSources addFile(ResourceLocation file) {
            Preconditions.checkNotNull((Object)file, (Object)"File must not be null");
            this._sources.add((SpriteSource)new SingleFile(file, Optional.empty()));
            return this;
        }

        public AtlasSpriteSources addFile(ResourceLocation file, ResourceLocation spriteId) {
            Preconditions.checkNotNull((Object)file, (Object)"File must not be null");
            Preconditions.checkNotNull((Object)spriteId, (Object)"Sprite ID must not be null");
            this._sources.add((SpriteSource)new SingleFile(file, Optional.of(spriteId)));
            return this;
        }

        public AtlasSpriteSources addFile(String nameSuffix, ResourceLocationBuilder idBuilder, String ... path) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)nameSuffix) ? 1 : 0) != 0, (Object)"Name suffix must not be null or empty");
            Preconditions.checkNotNull((Object)idBuilder, (Object)"ID builder must not be null");
            return this.addFile(idBuilder.appendPath(path).buildWithSuffix(nameSuffix));
        }

        public AtlasSpriteSources addDirectory(String sourcePath) {
            return this.addDirectory(sourcePath, "");
        }

        public AtlasSpriteSources addDirectory(String sourcePath, String prefix) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)sourcePath) ? 1 : 0) != 0, (Object)"Source path must not be null or empty");
            Preconditions.checkNotNull((Object)prefix, (Object)"Prefix I must not be null");
            this._sources.add((SpriteSource)new DirectoryLister(sourcePath, prefix));
            return this;
        }
    }
}

