/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.entity;

import com.sammy.malum.common.entity.bolt.AbstractBoltProjectileEntity;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumParticles;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import com.sammy.malum.visual_effects.networked.staff.BoltImpactParticleEffect;
import com.strawberry.gaze.GazeMod;
import com.strawberry.gaze.registry.GazeEntityRegistry;
import java.awt.Color;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.helpers.ColorHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.behaviors.DirectionalParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;

public class SeidhrBoltEntity
extends AbstractBoltProjectileEntity {
    public SeidhrBoltEntity(Level level) {
        super((EntityType)GazeEntityRegistry.SEIDHR_BOLT.get(), level);
        this.noPhysics = true;
    }

    public SeidhrBoltEntity(Level level, double pX, double pY, double pZ) {
        this(level);
        this.setPos(pX, pY, pZ);
        this.noPhysics = true;
    }

    public int getMaxAge() {
        return 40;
    }

    public BoltImpactParticleEffect getImpactParticleEffect() {
        return MalumParticleEffectTypes.HEX_BOLT_IMPACT;
    }

    public MalumNetworkedParticleEffectColorData getImpactParticleColor() {
        return new MalumNetworkedParticleEffectColorData(new MalumSpiritType[]{this.getRandomSpirit()});
    }

    protected Item getDefaultItem() {
        return (Item)GazeMod.SEIDHR.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnParticles() {
        Level level = this.level();
        Vec3 position = this.position();
        float scalar = this.getVisualEffectScalar();
        Vec3 norm = this.getDeltaMovement().normalize().scale((double)0.05f);
        ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs((Level)level, (Vec3)position, (MalumSpiritType)MalumSpiritTypes.INFERNAL_SPIRIT);
        lightSpecs.getBuilder().setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).multiplyLifetime(1.25f).setMotion(norm);
        lightSpecs.getBloomBuilder().setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).multiplyLifetime(1.25f).setMotion(norm);
        lightSpecs.spawnParticles();
        SpinParticleData spinData = SpinParticleData.createRandomDirection((RandomSource)this.random, (float)RandomHelper.randomBetween((RandomSource)this.random, (float)0.25f, (float)0.5f)).randomSpinOffset(this.random).build();
        Consumer<LodestoneWorldParticle> behavior = p -> p.setParticleSpeed(p.getParticleSpeed().scale((double)0.95f));
        WorldParticleBuilder.create((Supplier)MalumParticles.THIN_SLASH).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional((Vec3)this.getDeltaMovement().normalize())).setTransparencyData(GenericParticleData.create((float)(0.9f * scalar), (float)(0.4f * scalar), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setScaleData(GenericParticleData.create((float)(1.0f * scalar), (float)(0.5f * scalar)).setEasing(Easing.SINE_IN_OUT).build()).setColorData(MalumSpiritTypes.INFERNAL_SPIRIT.createColorData().build()).setSpritePicker(SimpleParticleOptions.ParticleSpritePicker.WITH_AGE).setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).setLifetime(Math.min(6 + this.age * 3, 30)).addTickActor(behavior).setSpinData(spinData).enableForcedSpawn().enableNoClip().spawn(level, position.x, position.y, position.z).setScaleData(GenericParticleData.create((float)(0.5f * scalar), (float)(0.3f * scalar)).setEasing(Easing.SINE_IN_OUT).build()).setTransparencyData(GenericParticleData.create((float)(0.4f * scalar), (float)(0.2f * scalar), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).setColorData(ColorParticleData.create((Color)ColorHelper.darker((Color)MalumSpiritTypes.INFERNAL_SPIRIT.getPrimaryColor(), (int)2)).build()).spawn(level, position.x, position.y, position.z);
    }

    private MalumSpiritType getRandomSpirit() {
        float value = this.random.nextFloat();
        if (value < 0.5f) {
            return MalumSpiritTypes.ARCANE_SPIRIT;
        }
        return MalumSpiritTypes.ELDRITCH_SPIRIT;
    }
}

