/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.item.curiosities.curios.necklaces;

import com.google.common.collect.Multimap;
import com.sammy.malum.MalumMod;
import com.sammy.malum.common.data.attachment.StaffAbilityData;
import com.sammy.malum.common.data.component.SoulwovenPouchContentsComponent;
import com.sammy.malum.common.item.IMalumEventResponder;
import com.sammy.malum.common.item.IVoidItem;
import com.sammy.malum.common.item.curiosities.SoulwovenPouchItem;
import com.sammy.malum.common.item.curiosities.curios.AbstractMalumCurioItem;
import com.sammy.malum.common.item.curiosities.curios.MalumCurioItem;
import com.sammy.malum.common.item.curiosities.weapons.staff.AbstractStaffItem;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.events.CollectSpiritEvent;
import com.sammy.malum.registry.common.MalumAttachmentTypes;
import com.sammy.malum.registry.common.MalumAttributes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.item.MalumDataComponents;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import top.theillusivec4.curios.api.SlotContext;

public class CurioChargeNecklace
extends MalumCurioItem
implements IMalumEventResponder,
IVoidItem {
    public CurioChargeNecklace(Item.Properties builder) {
        super(builder, AbstractMalumCurioItem.MalumTrinketType.VOID);
    }

    public void addExtraTooltipLines(Consumer<Component> consumer) {
        consumer.accept(ComponentHelper.positiveCurioEffect((String)"charge_necklace", (Object[])new Object[0]));
        consumer.accept(ComponentHelper.positiveCurioEffect((String)"charge_necklace_1", (Object[])new Object[0]));
    }

    public void addAttributeModifiers(Multimap<Holder<Attribute>, AttributeModifier> map, SlotContext slotContext, ItemStack stack) {
        this.addAttributeModifier(map, (Holder)MalumAttributes.CHARGE_DURATION, new AttributeModifier(MalumMod.malumPath((String)"mirror_necklace"), (double)0.15f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        boolean holdingStaff;
        LivingEntity wearer = slotContext.entity();
        if (wearer.tickCount % 40 != 0 || wearer.level().isClientSide || !(wearer instanceof Player)) {
            return;
        }
        Player player = (Player)wearer;
        boolean bl = holdingStaff = player.getMainHandItem().getItem() instanceof AbstractStaffItem || player.getOffhandItem().getItem() instanceof AbstractStaffItem;
        if (!holdingStaff) {
            return;
        }
        StaffAbilityData abilityData = (StaffAbilityData)player.getData(MalumAttachmentTypes.STAFF_ABILITIES);
        int debt = abilityData.getStaffChargeDebt();
        if (debt < 2) {
            return;
        }
        for (ItemStack item : player.getInventory().items) {
            Item item2 = item.getItem();
            if (!(item2 instanceof SoulwovenPouchItem)) continue;
            SoulwovenPouchItem pouch = (SoulwovenPouchItem)item2;
            SoulwovenPouchContentsComponent contents = (SoulwovenPouchContentsComponent)item.get((Supplier)MalumDataComponents.SOULWOVEN_POUCH_CONTENTS);
            if (contents == null || contents.isEmpty()) continue;
            SoulwovenPouchContentsComponent.Mutable mutable = new SoulwovenPouchContentsComponent.Mutable(contents);
            List pouchItems = contents.itemCopyStream().toList();
            for (int i = 0; i < pouchItems.size(); ++i) {
                ItemStack inner = (ItemStack)pouchItems.get(i);
                if (!(inner.getItem() instanceof SpiritShardItem)) continue;
                inner.shrink(1);
                if (inner.isEmpty()) {
                    mutable.removeOne();
                } else {
                    mutable.removeOne();
                    mutable.tryInsert(inner);
                }
                item.set((Supplier)MalumDataComponents.SOULWOVEN_POUCH_CONTENTS, (Object)mutable.toImmutable());
                pouch.playRemoveOneSound((Entity)player);
                SoundHelper.playSound((Entity)player, (SoundEvent)((SoundEvent)MalumSoundEvents.WORLDSOUL_MOTIF_LIGHT_IMPACT.get()), (SoundSource)player.getSoundSource(), (float)1.5f, (float)RandomHelper.randomBetween((RandomSource)player.getRandom(), (float)0.75f, (float)1.25f));
                abilityData.reduceStaffChargeCooldown((LivingEntity)player, 500);
                return;
            }
        }
    }

    public void spiritCollectionEvent(CollectSpiritEvent event, LivingEntity collector, double arcaneResonance) {
        if (collector instanceof ServerPlayer) {
            boolean holdingStaff;
            ServerPlayer player = (ServerPlayer)collector;
            boolean bl = holdingStaff = player.getMainHandItem().getItem() instanceof AbstractStaffItem || player.getOffhandItem().getItem() instanceof AbstractStaffItem;
            if (!holdingStaff) {
                return;
            }
            StaffAbilityData abilityData = (StaffAbilityData)player.getData(MalumAttachmentTypes.STAFF_ABILITIES);
            abilityData.reduceStaffChargeCooldown((LivingEntity)player, (int)(100.0 * arcaneResonance));
        }
    }
}

