/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.item.curiosities.weapons;

import com.sammy.malum.MalumMod;
import com.sammy.malum.common.data.attachment.StaffAbilityData;
import com.sammy.malum.common.data.attachment.soul_data.LivingSoulData;
import com.sammy.malum.common.item.curiosities.weapons.staff.AbstractStaffItem;
import com.sammy.malum.common.item.spirit.ISpiritAffiliatedItem;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.spirit.EntitySpiritDropData;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.MalumAttachmentTypes;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumParticles;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import com.sammy.malum.visual_effects.networked.staff.UnwindingChaosChargeParticleEffect;
import com.strawberry.gaze.common.entity.SeidhrBoltEntity;
import java.util.function.Supplier;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.AddAttributeTooltipsEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.registry.common.LodestoneAttributes;
import team.lodestar.lodestone.registry.common.tag.LodestoneDamageTypeTags;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.item.LodestoneItemProperties;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectExtraData;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.behaviors.DirectionalParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;

public class SeidhrItem
extends AbstractStaffItem
implements ISpiritAffiliatedItem {
    public SeidhrItem(Tier tier, float magicDamage, float chargeDuration, int chargeCapacity, LodestoneItemProperties properties) {
        super(tier, magicDamage, chargeDuration, chargeCapacity, properties);
    }

    public void modifyAttributeTooltipEvent(AddAttributeTooltipsEvent event) {
        event.addTooltipLines(new Component[]{ComponentHelper.positiveEffect((String)"soul_based_damage", (Object[])new Object[0])});
        event.addTooltipLines(new Component[]{ComponentHelper.positiveEffect((String)"unwinding_chaos_volley", (Object[])new Object[0])});
        event.addTooltipLines(new Component[]{ComponentHelper.positiveEffect((String)"seidhr_death", (Object[])new Object[0])});
    }

    public MalumSpiritType getDefiningSpiritType() {
        MalumSpiritType[] spirits = new MalumSpiritType[]{MalumSpiritTypes.ARCANE_SPIRIT, MalumSpiritTypes.INFERNAL_SPIRIT, MalumSpiritTypes.ELDRITCH_SPIRIT};
        return spirits[MalumMod.RANDOM.nextInt(spirits.length)];
    }

    public void outgoingDeathEvent(LivingDeathEvent event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        Level level = attacker.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!((LivingSoulData)target.getData(MalumAttachmentTypes.LIVING_SOUL_INFO)).shouldDropSpirits()) {
            return;
        }
        this.addStaffCharges(serverLevel, attacker, target, 160);
    }

    public void finalizedOutgoingDamageEvent(LivingDamageEvent.Post event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        DamageSource source = event.getSource();
        Level level = attacker.level();
        RandomSource random = level.random;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        this.addStaffCharges(serverLevel, attacker, target, 40);
        boolean canTriggerMagic = source.is(LodestoneDamageTypeTags.CAN_TRIGGER_MAGIC);
        if (canTriggerMagic) {
            float magicDamage = EntitySpiritDropData.getSpiritData((LivingEntity)target).map(d -> d.getTotalSpirits()).orElse(0).intValue();
            if (target instanceof Player) {
                magicDamage = 2.0f * Math.max(1.0f, (1.0f + (float)target.getArmorValue() / 12.0f) * (1.0f + (1.0f - 1.0f / (float)target.getArmorValue())) / 12.0f);
            }
            for (int i = 0; i < 3; ++i) {
                MalumParticleEffectTypes.STAFF_SLAM.createEffect().originatesFrom((Entity)attacker).targets((Entity)target).randomOffset(random, 0.3f, 0.8f * (float)(random.nextBoolean() ? 1 : -1)).forwardOffset(1.4f).upwardOffset(0.3f).deviation(0.2f).randomDeviationAngle(random).color(stack.getItem()).spawn(serverLevel);
            }
            float pitch = RandomHelper.randomBetween((RandomSource)level.getRandom(), (float)0.75f, (float)2.0f);
            SoundHelper.playSound((Entity)attacker, (SoundEvent)((SoundEvent)MalumSoundEvents.WORLDSOUL_MOTIF_HEAVY_IMPACT.get()), (float)2.0f, (float)pitch);
        }
    }

    public int getProjectileCount(Level level, LivingEntity livingEntity, float pct) {
        if (pct == 1.0f) {
            StaffAbilityData data = (StaffAbilityData)livingEntity.getData(MalumAttachmentTypes.STAFF_ABILITIES);
            return 5 + data.consumeAllStaffCharges(livingEntity) * 2;
        }
        if (pct >= 0.5f) {
            return 1;
        }
        return 0;
    }

    public void fireProjectile(LivingEntity player, ItemStack stack, Level level, InteractionHand hand, int count) {
        int ceil = Mth.ceil((float)((float)count / 2.0f));
        int spawnDelay = 1 + ceil * 2;
        float spread = count > 0 ? (float)(ceil %= 7) * 0.1f * (float)((long)count % 2L == 0L ? 1 : -1) : 0.0f;
        float pitchOffset = count > 4 ? 2.0f + (2.0f - (float)ceil * 1.5f) : 0.5f;
        float velocity = 3.0f;
        float magicDamage = (float)player.getAttributes().getValue((Holder)LodestoneAttributes.MAGIC_DAMAGE);
        Vec3 pos = this.getProjectileSpawnPos(player, hand, 0.5f, 0.5f);
        SeidhrBoltEntity entity = new SeidhrBoltEntity(level, pos.x, pos.y, pos.z);
        entity.setData(player, magicDamage, spawnDelay);
        entity.setItem(stack);
        entity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), -pitchOffset, velocity, 0.0f);
        Vec3 projectileDirection = entity.getDeltaMovement();
        float yRot = (float)(Mth.atan2((double)projectileDirection.x, (double)projectileDirection.z) * 57.2957763671875);
        float yaw = (float)Math.toRadians(yRot);
        Vec3 left = new Vec3(-Math.cos(yaw), 0.0, Math.sin(yaw));
        entity.setDeltaMovement(entity.getDeltaMovement().add(left.scale((double)spread)));
        level.addFreshEntity((Entity)entity);
    }

    public void addStaffCharges(ServerLevel serverLevel, LivingEntity attacker, LivingEntity target, int charge) {
        ((StaffAbilityData)attacker.getData(MalumAttachmentTypes.STAFF_ABILITIES)).reduceStaffChargeCooldown(attacker, charge);
        float pitch = RandomHelper.randomBetween((RandomSource)attacker.getRandom(), (float)0.75f, (float)1.25f);
        SoundHelper.playSound((Entity)target, (SoundEvent)((SoundEvent)MalumSoundEvents.WORLDSOUL_MOTIF_LIGHT_IMPACT.get()), (SoundSource)attacker.getSoundSource(), (float)1.5f, (float)pitch);
        MalumParticleEffectTypes.UNWINDING_CHAOS_CHARGE.createEffect((Entity)target).color(new MalumSpiritType[]{this.getDefiningSpiritType()}).customData((NetworkedParticleEffectExtraData)new UnwindingChaosChargeParticleEffect.UnwindingChaosChargeEffectData(attacker.getId())).spawn(serverLevel);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnChargeParticles(Level pLevel, LivingEntity pLivingEntity, Vec3 pos, ItemStack pStack, float pct) {
        RandomSource random = pLevel.random;
        WorldParticleBuilder.create((Supplier)MalumParticles.HEXAGON).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional((Vec3)pLivingEntity.getLookAngle().normalize())).setSpinData(SpinParticleData.createRandomDirection((RandomSource)random, (float)0.1f, (float)0.2f).setSpinOffset(RandomHelper.randomBetween((RandomSource)random, (float)-0.314f, (float)0.314f)).build()).setTransparencyData(GenericParticleData.create((float)(0.5f * pct), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setScaleData(GenericParticleData.create((float)(0.3f * pct), (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setMotion(pLivingEntity.getLookAngle().normalize().scale((double)(0.2f * pct))).setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).setColorData(MalumSpiritTypes.ELDRITCH_SPIRIT.createColorData().build()).enableForcedSpawn().setLifeDelay(2).setLifetime(5).enableNoClip().spawn(pLevel, pos.x, pos.y, pos.z).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).spawn(pLevel, pos.x, pos.y, pos.z);
        WorldParticleBuilder.create((Supplier)MalumParticles.HEXAGON).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional((Vec3)pLivingEntity.getLookAngle().normalize())).setSpinData(SpinParticleData.createRandomDirection((RandomSource)random, (float)-0.1f, (float)-0.2f).setSpinOffset(RandomHelper.randomBetween((RandomSource)random, (float)-0.314f, (float)0.314f)).build()).setTransparencyData(GenericParticleData.create((float)(0.5f * pct), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setScaleData(GenericParticleData.create((float)(0.2f * pct), (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setMotion(pLivingEntity.getLookAngle().normalize().scale((double)(0.2f * pct))).setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).setColorData(MalumSpiritTypes.ARCANE_SPIRIT.createColorData().build()).enableForcedSpawn().setLifeDelay(2).setLifetime(5).enableNoClip().spawn(pLevel, pos.x, pos.y, pos.z).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).spawn(pLevel, pos.x, pos.y, pos.z);
        WorldParticleBuilder.create((Supplier)MalumParticles.SPARK).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional((Vec3)pLivingEntity.getLookAngle().normalize())).setSpinData(SpinParticleData.createRandomDirection((RandomSource)random, (float)-0.1f, (float)-0.2f).setSpinOffset(RandomHelper.randomBetween((RandomSource)random, (float)-0.314f, (float)0.314f)).build()).setTransparencyData(GenericParticleData.create((float)(0.5f * pct), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setScaleData(GenericParticleData.create((float)(0.1f * pct), (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setMotion(pLivingEntity.getLookAngle().normalize().scale((double)(0.2f * pct))).setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).setColorData(MalumSpiritTypes.INFERNAL_SPIRIT.createColorData().build()).enableForcedSpawn().setLifeDelay(2).setLifetime(5).enableNoClip().spawn(pLevel, pos.x, pos.y, pos.z).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).spawn(pLevel, pos.x, pos.y, pos.z);
    }
}

