/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.spiritrite.arcane;

import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.core.systems.rite.TotemicRiteEffect;
import com.sammy.malum.core.systems.rite.TotemicRiteType;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.phys.Vec3;

public class GazeLesserAerialRiteType
extends TotemicRiteType {
    public GazeLesserAerialRiteType() {
        super("gaze_lesser_aerial_rite", new MalumSpiritType[]{MalumSpiritTypes.ELDRITCH_SPIRIT, MalumSpiritTypes.AERIAL_SPIRIT, MalumSpiritTypes.AERIAL_SPIRIT});
    }

    public TotemicRiteEffect getNaturalRiteEffect() {
        return new TotemicRiteEffect(this, TotemicRiteEffect.MalumRiteEffectCategory.LIVING_ENTITY_EFFECT){

            protected void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                if (totemBase.activeRite == null) {
                    return;
                }
                Vec3 center = Vec3.atCenterOf((Vec3i)this.getRiteEffectCenter(totemBase));
                this.getNearbyEntities(totemBase, Entity.class, e -> !(e instanceof ItemEntity)).forEach(entity -> {
                    Vec3 direction = center.subtract(entity.position()).normalize().scale(0.5);
                    entity.setDeltaMovement(entity.getDeltaMovement().add(direction));
                    entity.hurtMarked = true;
                });
            }
        };
    }

    public TotemicRiteEffect getCorruptedEffect() {
        return new TotemicRiteEffect(this, TotemicRiteEffect.MalumRiteEffectCategory.LIVING_ENTITY_EFFECT){

            protected void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                if (totemBase.activeRite == null) {
                    return;
                }
                Vec3 center = Vec3.atCenterOf((Vec3i)this.getRiteEffectCenter(totemBase));
                this.getNearbyEntities(totemBase, Entity.class, e -> !(e instanceof ItemEntity)).forEach(entity -> {
                    Vec3 direction = entity.position().subtract(center).normalize().scale(0.5);
                    entity.setDeltaMovement(entity.getDeltaMovement().add(direction));
                    entity.hurtMarked = true;
                });
            }
        };
    }
}

