/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.block;

import com.blakebr0.cucumber.block.BaseTileEntityBlock;
import com.blakebr0.cucumber.helper.BlockHelper;
import com.blakebr0.extendedcrafting.init.ModTileEntities;
import com.blakebr0.extendedcrafting.tileentity.FluxCrafterTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class FluxCrafterBlock
extends BaseTileEntityBlock {
    public FluxCrafterBlock() {
        super(SoundType.METAL, 6.0f, 12.0f, true);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FluxCrafterTileEntity(pos, state);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity tile;
        if (!level.isClientSide() && (tile = level.getBlockEntity(pos)) instanceof FluxCrafterTileEntity) {
            FluxCrafterTileEntity table = (FluxCrafterTileEntity)tile;
            player.openMenu((MenuProvider)table, pos);
        }
        return ItemInteractionResult.SUCCESS;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tile;
        if (state.getBlock() != newState.getBlock() && (tile = level.getBlockEntity(pos)) instanceof FluxCrafterTileEntity) {
            FluxCrafterTileEntity table = (FluxCrafterTileEntity)tile;
            Containers.dropContents((Level)level, (BlockPos)pos, (NonNullList)table.getInventory().getStacks());
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return BlockHelper.getRedstoneSignalFromInventory((BlockEntity)level.getBlockEntity(pos));
    }

    protected <T extends BlockEntity> BlockEntityTicker<T> getServerTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return FluxCrafterBlock.createTicker(type, (BlockEntityType)((BlockEntityType)ModTileEntities.FLUX_CRAFTER.get()), FluxCrafterTileEntity::tick);
    }
}

