/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.container;

import com.blakebr0.cucumber.container.BaseContainerMenu;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.extendedcrafting.api.TableCraftingInput;
import com.blakebr0.extendedcrafting.api.crafting.ITableRecipe;
import com.blakebr0.extendedcrafting.container.inventory.ExtendedCraftingInventory;
import com.blakebr0.extendedcrafting.container.slot.TableOutputSlot;
import com.blakebr0.extendedcrafting.init.ModMenuTypes;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import com.blakebr0.extendedcrafting.tileentity.AdvancedTableTileEntity;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class AdvancedTableContainer
extends BaseContainerMenu {
    private final Level level;
    private final Container result;
    private final ExtendedCraftingInventory matrix;

    private AdvancedTableContainer(MenuType<?> type, int id, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(type, id, playerInventory, AdvancedTableTileEntity.createInventoryHandler(), buffer.readBlockPos());
    }

    private AdvancedTableContainer(MenuType<?> type, int id, Inventory playerInventory, BaseItemStackHandler inventory, BlockPos pos) {
        super(type, id, pos);
        int j;
        int i;
        this.level = playerInventory.player.level();
        this.result = new ResultContainer();
        this.matrix = new ExtendedCraftingInventory((AbstractContainerMenu)this, inventory, 5);
        this.addSlot(new TableOutputSlot((AbstractContainerMenu)this, this.matrix, this.result, 0, 142, 53));
        for (i = 0; i < 5; ++i) {
            for (j = 0; j < 5; ++j) {
                this.addSlot(new Slot((Container)this.matrix, j + i * 5, 14 + j * 18, 18 + i * 18));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 124 + i * 18));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.addSlot(new Slot((Container)playerInventory, j, 8 + j * 18, 182));
        }
        this.slotsChanged((Container)this.matrix);
    }

    public void slotsChanged(Container matrix) {
        if (this.level.isClientSide) {
            return;
        }
        TableCraftingInput inventory = this.matrix.asCraftInput();
        Optional recipe = this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipeTypes.TABLE.get(), (RecipeInput)inventory, this.level);
        if (recipe.isPresent()) {
            ItemStack result = ((ITableRecipe)((RecipeHolder)recipe.get()).value()).assemble((RecipeInput)inventory, (HolderLookup.Provider)this.level.registryAccess());
            this.result.setItem(0, result);
        } else {
            this.result.setItem(0, ItemStack.EMPTY);
        }
        super.slotsChanged(matrix);
    }

    public ItemStack quickMoveStack(Player player, int slotNumber) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotNumber);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (slotNumber == 0) {
                if (!this.moveItemStackTo(itemstack1, 26, 62, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (slotNumber >= 26 && slotNumber < 62 ? !this.moveItemStackTo(itemstack1, 1, 26, false) : !this.moveItemStackTo(itemstack1, 26, 62, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }

    public static AdvancedTableContainer create(int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        return new AdvancedTableContainer((MenuType)ModMenuTypes.ADVANCED_TABLE.get(), windowId, playerInventory, buffer);
    }

    public static AdvancedTableContainer create(int windowId, Inventory playerInventory, BaseItemStackHandler inventory, BlockPos pos) {
        return new AdvancedTableContainer((MenuType)ModMenuTypes.ADVANCED_TABLE.get(), windowId, playerInventory, inventory, pos);
    }
}

