/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.container;

import com.blakebr0.cucumber.container.BaseContainerMenu;
import com.blakebr0.extendedcrafting.init.ModMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class FluxAlternatorContainer
extends BaseContainerMenu {
    private FluxAlternatorContainer(MenuType<?> type, int id, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(type, id, playerInventory, buffer.readBlockPos());
    }

    private FluxAlternatorContainer(MenuType<?> type, int id, Inventory playerInventory, BlockPos pos) {
        super(type, id, pos);
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 112 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 170));
        }
    }

    public ItemStack quickMoveStack(Player player, int slotNumber) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotNumber);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (slotNumber < 27 ? !this.moveItemStackTo(itemstack1, 27, 36, false) : (slotNumber < 36 ? !this.moveItemStackTo(itemstack1, 0, 27, false) : !this.moveItemStackTo(itemstack1, 0, 27, false))) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }

    public static FluxAlternatorContainer create(int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        return new FluxAlternatorContainer((MenuType)ModMenuTypes.FLUX_ALTERNATOR.get(), windowId, playerInventory, buffer);
    }

    public static FluxAlternatorContainer create(int windowId, Inventory playerInventory, BlockPos pos) {
        return new FluxAlternatorContainer((MenuType)ModMenuTypes.FLUX_ALTERNATOR.get(), windowId, playerInventory, pos);
    }
}

