/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.crafting.recipe;

import com.blakebr0.extendedcrafting.api.crafting.IFluxCrafterRecipe;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.init.ModRecipeSerializers;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.RecipeMatcher;

public class ShapelessFluxCrafterRecipe
implements IFluxCrafterRecipe {
    private final NonNullList<Ingredient> inputs;
    private final ItemStack result;
    private final int powerRequired;
    private final int powerRate;

    public ShapelessFluxCrafterRecipe(NonNullList<Ingredient> inputs, ItemStack result, int powerRequired, int powerRate) {
        this.inputs = inputs;
        this.result = result;
        this.powerRequired = powerRequired;
        this.powerRate = powerRate;
    }

    public boolean matches(CraftingInput inventory, Level level) {
        if (this.inputs.size() != inventory.ingredientCount()) {
            return false;
        }
        NonNullList inputs = NonNullList.create();
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack item = inventory.getItem(i);
            if (item.isEmpty()) continue;
            inputs.add((Object)item);
        }
        return RecipeMatcher.findMatches((List)inputs, this.inputs) != null;
    }

    public ItemStack assemble(CraftingInput inventory, HolderLookup.Provider lookup) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= this.inputs.size();
    }

    public ItemStack getResultItem(HolderLookup.Provider lookup) {
        return this.result;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.inputs;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.SHAPELESS_FLUX_CRAFTER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipeTypes.FLUX_CRAFTER.get();
    }

    public boolean isSpecial() {
        return true;
    }

    @Override
    public int getPowerRequired() {
        return this.powerRequired;
    }

    @Override
    public int getPowerRate() {
        return this.powerRate;
    }

    public static class Serializer
    implements RecipeSerializer<ShapelessFluxCrafterRecipe> {
        public static final MapCodec<ShapelessFluxCrafterRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(field -> {
            int max = 9;
            Object[] ingredients = (Ingredient[])field.toArray(Ingredient[]::new);
            if (ingredients.length == 0) {
                return DataResult.error(() -> "No ingredients for Combination recipe");
            }
            return ingredients.length > max ? DataResult.error(() -> "Too many ingredients for Combination recipe. The maximum is: %s".formatted(max)) : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])ingredients));
        }, DataResult::success).forGetter(recipe -> recipe.inputs), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.INT.fieldOf("power_required").forGetter(recipe -> recipe.powerRequired), (App)Codec.INT.optionalFieldOf("power_rate", (Object)((Integer)ModConfigs.FLUX_CRAFTER_POWER_RATE.get())).forGetter(recipe -> recipe.powerRequired)).apply((Applicative)builder, ShapelessFluxCrafterRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ShapelessFluxCrafterRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<ShapelessFluxCrafterRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ShapelessFluxCrafterRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static ShapelessFluxCrafterRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            int size = buffer.readVarInt();
            NonNullList inputs = NonNullList.withSize((int)size, (Object)Ingredient.EMPTY);
            for (int i = 0; i < size; ++i) {
                inputs.set(i, (Object)((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer)));
            }
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            int powerRequired = buffer.readVarInt();
            int powerRate = buffer.readVarInt();
            return new ShapelessFluxCrafterRecipe((NonNullList<Ingredient>)inputs, result, powerRequired, powerRate);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, ShapelessFluxCrafterRecipe recipe) {
            buffer.writeVarInt(recipe.inputs.size());
            for (Ingredient ingredient : recipe.inputs) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
            buffer.writeVarInt(recipe.powerRequired);
            buffer.writeVarInt(recipe.powerRate);
        }
    }
}

