/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.compat;

import com.cazsius.solcarrot.api.FoodCapability;
import com.cazsius.solcarrot.api.SOLCarrotAPI;
import java.util.Comparator;
import net.blay09.mods.cookingforblockheads.api.CookingForBlockheadsAPI;
import net.blay09.mods.cookingforblockheads.api.ISortButton;
import net.blay09.mods.cookingforblockheads.crafting.RecipeWithStatus;
import net.blay09.mods.cookingforblockheads.menu.comparator.ComparatorName;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class SpiceOfLifeAddon {
    public SpiceOfLifeAddon() {
        CookingForBlockheadsAPI.addSortButton(new ISortButton(this){
            private final ComparatorName fallback = new ComparatorName();
            private static final ResourceLocation icon = ResourceLocation.fromNamespaceAndPath((String)"cookingforblockheads", (String)"textures/gui/gui.png");

            @Override
            public ResourceLocation getIcon() {
                return icon;
            }

            @Override
            public Component getTooltip() {
                return Component.translatable((String)"tooltip.cookingforblockheads.sort_by_eatenness");
            }

            @Override
            public Comparator<RecipeWithStatus> getComparator(Player player) {
                return (o1, o2) -> {
                    FoodCapability foodCapability = SOLCarrotAPI.getFoodCapability((Player)player);
                    boolean isEdibleO1 = o1.resultItem().has(DataComponents.FOOD);
                    boolean isEdibleO2 = o2.resultItem().has(DataComponents.FOOD);
                    boolean hasEatenO1 = foodCapability.hasEaten(o1.resultItem().getItem());
                    boolean hasEatenO2 = foodCapability.hasEaten(o2.resultItem().getItem());
                    if (isEdibleO1 && !isEdibleO2) {
                        return -1;
                    }
                    if (!isEdibleO1 && isEdibleO2) {
                        return 1;
                    }
                    if (isEdibleO1 && isEdibleO2) {
                        if (!hasEatenO1 && hasEatenO2) {
                            return -1;
                        }
                        if (hasEatenO1 && !hasEatenO2) {
                            return 1;
                        }
                    }
                    return this.fallback.compare((RecipeWithStatus)o1, (RecipeWithStatus)o2);
                };
            }

            @Override
            public int getIconTextureX() {
                return 236;
            }

            @Override
            public int getIconTextureY() {
                return 60;
            }
        });
    }
}

