/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.crafting;

import java.util.List;
import net.blay09.mods.cookingforblockheads.api.IngredientToken;
import net.blay09.mods.cookingforblockheads.api.KitchenRecipeHandler;
import net.blay09.mods.cookingforblockheads.crafting.CraftingContext;
import net.blay09.mods.cookingforblockheads.crafting.TransientHeadlessCraftingContainer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeInput;

public abstract class AbstractKitchenCraftingRecipeHandler<T extends CraftingRecipe>
implements KitchenRecipeHandler<T> {
    @Override
    public ItemStack assemble(CraftingContext context, T recipe, List<IngredientToken> ingredientTokens, RegistryAccess registryAccess) {
        TransientHeadlessCraftingContainer craftingContainer = new TransientHeadlessCraftingContainer(3, 3);
        for (int i = 0; i < ingredientTokens.size(); ++i) {
            IngredientToken ingredientToken = ingredientTokens.get(i);
            int matrixSlot = this.mapToMatrixSlot(recipe, i);
            craftingContainer.setItem(matrixSlot, ingredientToken.consume());
        }
        CraftingInput craftInput = craftingContainer.asCraftInput();
        NonNullList remainingItems = recipe.getRemainingItems((RecipeInput)craftInput);
        for (int i = 0; i < remainingItems.size(); ++i) {
            IngredientToken ingredientToken = i < ingredientTokens.size() ? ingredientTokens.get(i) : IngredientToken.EMPTY;
            ItemStack restItem = ingredientToken.restore((ItemStack)remainingItems.get(i));
            if (restItem.isEmpty()) continue;
            context.restore(restItem);
        }
        return recipe.assemble((RecipeInput)craftInput, (HolderLookup.Provider)registryAccess);
    }
}

