/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.growthacceleratortiers.blockentity;

import appeng.api.ids.AETags;
import dev.satherov.growthacceleratortiers.block.GATMonoBlock;
import dev.satherov.growthacceleratortiers.blockentity.GATGrowthAcceleratorBlockEntity;
import dev.satherov.growthacceleratortiers.core.GATConfig;
import dev.satherov.growthacceleratortiers.data.PositionAttachment;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;

public abstract class GATMonoBlockEntity
extends GATGrowthAcceleratorBlockEntity {
    private boolean cache = false;
    private int cooldown = 0;

    public GATMonoBlockEntity(int maxStoredPower, int powerPerTick, double multiplier, BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(maxStoredPower, powerPerTick, multiplier, blockEntityType, pos, blockState);
    }

    @Override
    protected void onTick(int ticksSinceLastCall) {
        Level level = this.getLevel();
        if (!(level instanceof ServerLevel)) {
            if (!this.cache) {
                super.onTick(ticksSinceLastCall);
            }
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        boolean conflicted = this.cache;
        boolean check = false;
        if (this.cooldown > 0) {
            this.cooldown -= ticksSinceLastCall;
        }
        if (this.cooldown <= 0) {
            check = true;
            this.cooldown = 40;
        }
        if (check) {
            conflicted = false;
            for (Direction dir : Direction.values()) {
                GATMonoBlock block;
                PositionAttachment data;
                BlockPos relative = this.getBlockPos().relative(dir).immutable();
                BlockState state = level2.getBlockState(relative);
                if (!state.is(AETags.GROWTH_ACCELERATABLE)) continue;
                LevelChunk chunk = level2.getChunkAt(relative);
                Block block2 = this.getBlockState().getBlock();
                if (!(block2 instanceof GATMonoBlock) || (data = (PositionAttachment)chunk.getData((block = (GATMonoBlock)block2).getAttachmentType())).get(relative) <= 1 || !GATConfig.instance().enableConflicts()) continue;
                conflicted = true;
                break;
            }
        }
        if (conflicted != (Boolean)this.getBlockState().getValue((Property)GATMonoBlock.CONFLICTED)) {
            level2.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)GATMonoBlock.CONFLICTED, (Comparable)Boolean.valueOf(conflicted)));
        }
        this.cache = conflicted;
        if (!this.cache) {
            super.onTick(ticksSinceLastCall);
        }
    }
}

