/*
 * Decompiled with CFR 0.152.
 */
package lu.kolja.expandedae.terminal;

import appeng.api.config.Actionable;
import appeng.api.networking.IGridNode;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableItem;
import appeng.core.definitions.AEItems;
import appeng.helpers.IPatternTerminalMenuHost;
import appeng.menu.me.items.PatternEncodingTermMenu;
import appeng.menu.slot.RestrictedInputSlot;
import appeng.util.ConfigInventory;
import java.util.Objects;
import java.util.Optional;
import lu.kolja.expandedae.definition.ExpItems;
import lu.kolja.expandedae.definition.ExpMenus;
import lu.kolja.expandedae.helper.misc.KeybindUtil;
import lu.kolja.expandedae.mixin.accessor.AccessorPatternEncodingTermMenu;
import lu.kolja.expandedae.terminal.wtlib.ExpWETMenu;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ExpEncodingTerminalMenu
extends PatternEncodingTermMenu {
    public ExpEncodingTerminalMenu(int id, Inventory ip, IPatternTerminalMenuHost host) {
        this(ExpMenus.EXP_ENCODING_TERMINAL.get(), id, ip, host);
    }

    public ExpEncodingTerminalMenu(MenuType<?> menuType, int id, Inventory ip, IPatternTerminalMenuHost host) {
        super(menuType, id, ip, host, true);
        this.registerClientAction("modifyPattern", Integer.class, this::modifyPattern);
    }

    public void encode() {
        ExpWETMenu wetMenu;
        RestrictedInputSlot blankPatternSlot;
        IGridNode node;
        block8: {
            block7: {
                ExpEncodingTerminalMenu expEncodingTerminalMenu;
                super.encode();
                node = this.getGridNode();
                Optional source = this.getActionSource().player();
                assert (source.isPresent());
                Player player = (Player)source.get();
                RestrictedInputSlot encodedPatternSlot = ((AccessorPatternEncodingTermMenu)((Object)this)).getEncodedPatternSlot();
                blankPatternSlot = ((AccessorPatternEncodingTermMenu)((Object)this)).getBlankPatternSlot();
                if (encodedPatternSlot.getItem() != ItemStack.EMPTY && KeybindUtil.isShiftDown() && player.getInventory().getFreeSlot() > 0) {
                    player.addItem(encodedPatternSlot.getItem());
                    encodedPatternSlot.set(ItemStack.EMPTY);
                    encodedPatternSlot.setChanged();
                }
                if (!((expEncodingTerminalMenu = this) instanceof ExpWETMenu)) break block7;
                wetMenu = (ExpWETMenu)expEncodingTerminalMenu;
                if (wetMenu.itemMenuHost != null) break block8;
            }
            return;
        }
        ItemStack terminalItem = wetMenu.itemMenuHost.getItemStack();
        IUpgradeInventory inventory = ((IUpgradeableItem)terminalItem.getItem()).getUpgrades(terminalItem);
        if (!inventory.isInstalled(ExpItems.PATTERN_REFILLER_CARD)) {
            return;
        }
        int blankPatternSlotCount = blankPatternSlot.getItem().getCount();
        if (node == null) {
            return;
        }
        int changed = (int)Objects.requireNonNull(node).getGrid().getStorageService().getInventory().extract((AEKey)AEItemKey.of((ItemLike)AEItems.BLANK_PATTERN), (long)(64 - blankPatternSlotCount), Actionable.MODULATE, this.getActionSource());
        blankPatternSlot.set(new ItemStack((ItemLike)AEItems.BLANK_PATTERN, blankPatternSlotCount + changed));
        blankPatternSlot.setChanged();
    }

    public void modifyPattern(Integer data) {
        if (this.isClientSide()) {
            this.sendClientAction("modifyPattern", data);
        } else {
            int slot;
            ConfigInventory encodedInputsInv = ((AccessorPatternEncodingTermMenu)((Object)this)).getEncodedInputsInv();
            ConfigInventory encodedOutputsInv = ((AccessorPatternEncodingTermMenu)((Object)this)).getEncodedOutputsInv();
            GenericStack[] output = ExpEncodingTerminalMenu.isValid(encodedOutputsInv, data);
            if (output == null) {
                return;
            }
            GenericStack[] input = ExpEncodingTerminalMenu.isValid(encodedInputsInv, data);
            if (input == null) {
                return;
            }
            for (slot = 0; slot < output.length; ++slot) {
                if (output[slot] == null) continue;
                encodedOutputsInv.setStack(slot, output[slot]);
            }
            for (slot = 0; slot < input.length; ++slot) {
                if (input[slot] == null) continue;
                encodedInputsInv.setStack(slot, input[slot]);
            }
        }
    }

    private static GenericStack[] isValid(ConfigInventory inv, int data) {
        boolean flag;
        boolean bl = flag = data > 0;
        if (!flag) {
            data = -data;
        }
        GenericStack[] result = new GenericStack[inv.size()];
        for (int slot = 0; slot < inv.size(); ++slot) {
            GenericStack stack = inv.getStack(slot);
            if (stack == null) continue;
            if (flag) {
                if ((long)data * stack.amount() > Integer.MAX_VALUE) {
                    return null;
                }
                result[slot] = new GenericStack(stack.what(), (long)data * stack.amount());
                continue;
            }
            if (stack.amount() % (long)data != 0L) {
                return null;
            }
            result[slot] = new GenericStack(stack.what(), stack.amount() / (long)data);
        }
        return result;
    }
}

