/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.block.entity;

import de.markusbordihn.easynpc.block.BaseEasyNPCSpawnerBlock;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.item.configuration.EasyNPCPresetItem;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.HashSet;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BaseEasyNPCSpawnerBlockEntity
extends BaseContainerBlockEntity {
    public static final int BLOCK_POS_X_DATA = 0;
    public static final int BLOCK_POS_Y_DATA = 1;
    public static final int BLOCK_POS_Z_DATA = 2;
    public static final int DATA_SIZE = 9;
    public static final int DELAY_DATA = 5;
    public static final String DELAY_TAG = "Delay";
    public static final int DESPAWN_RANGE_DATA = 8;
    public static final String DESPAWN_RANGE_TAG = "DespawnRange";
    public static final int MAX_NEARBY_ENTITIES_DATA = 6;
    public static final String MAX_NEARBY_ENTITIES_TAG = "MaxNearbyEntities";
    public static final String NAME = "easy_npc_spawner_entity";
    public static final int REQUIRED_PLAYER_RANGE_DATA = 4;
    public static final String REQUIRED_PLAYER_RANGE_TAG = "RequiredPlayerRange";
    public static final String SPAWNER_OWNER_TAG = "Owner";
    public static final int SPAWNER_TICK = 20;
    public static final int SPAWN_COUNT_DATA = 7;
    public static final String SPAWN_COUNT_TAG = "SpawnCount";
    public static final int SPAWN_RANGE_DATA = 3;
    public static final String SPAWN_RANGE_TAG = "SpawnRange";
    public static final String UUID_TAG = "UUID";
    private static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected final Random random = new Random();
    protected NonNullList<ItemStack> items = NonNullList.withSize((int)8, (Object)ItemStack.EMPTY);
    private int delay = 10;
    private int despawnRange = 32;
    private int maxNearbyEntities = 1;
    private int numbersPerSpawnInterval = 1;
    private UUID owner;
    private int requiredPlayerRange = 16;
    private int spawnRange = 2;
    protected final ContainerData dataAccess = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> BaseEasyNPCSpawnerBlockEntity.this.worldPosition.getX();
                case 1 -> BaseEasyNPCSpawnerBlockEntity.this.worldPosition.getY();
                case 2 -> BaseEasyNPCSpawnerBlockEntity.this.worldPosition.getZ();
                case 5 -> BaseEasyNPCSpawnerBlockEntity.this.delay;
                case 8 -> BaseEasyNPCSpawnerBlockEntity.this.despawnRange;
                case 6 -> BaseEasyNPCSpawnerBlockEntity.this.maxNearbyEntities;
                case 4 -> BaseEasyNPCSpawnerBlockEntity.this.requiredPlayerRange;
                case 7 -> BaseEasyNPCSpawnerBlockEntity.this.numbersPerSpawnInterval;
                case 3 -> BaseEasyNPCSpawnerBlockEntity.this.spawnRange;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 3: {
                    BaseEasyNPCSpawnerBlockEntity.this.spawnRange = value;
                    break;
                }
                case 8: {
                    BaseEasyNPCSpawnerBlockEntity.this.despawnRange = value;
                    break;
                }
                case 4: {
                    BaseEasyNPCSpawnerBlockEntity.this.requiredPlayerRange = value;
                    break;
                }
                case 5: {
                    BaseEasyNPCSpawnerBlockEntity.this.delay = value;
                    break;
                }
                case 6: {
                    BaseEasyNPCSpawnerBlockEntity.this.maxNearbyEntities = value;
                    break;
                }
                case 7: {
                    BaseEasyNPCSpawnerBlockEntity.this.numbersPerSpawnInterval = value;
                    break;
                }
            }
        }

        public int getCount() {
            return 9;
        }
    };
    private int spawnTicker = 0;
    private int spawnerTicker = this.random.nextInt(20);
    private UUID spawnerUUID;

    public BaseEasyNPCSpawnerBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public static void clientTick(Level level, BlockPos blockPos, BlockState blockState, BaseEasyNPCSpawnerBlockEntity blockEntity) {
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, BaseEasyNPCSpawnerBlockEntity blockEntity) {
        if (blockEntity.spawnerTicker++ >= 20) {
            if (blockEntity.spawnTicker++ >= blockEntity.delay) {
                BaseEasyNPCSpawnerBlockEntity.despawnTick(level, blockPos, blockState, blockEntity);
                BaseEasyNPCSpawnerBlockEntity.spawnTick(level, blockPos, blockState, blockEntity);
                blockEntity.spawnTicker = 0;
            }
            blockEntity.spawnerTicker = 0;
        }
    }

    public static void despawnTick(Level level, BlockPos blockPos, BlockState blockState, BaseEasyNPCSpawnerBlockEntity blockEntity) {
        if (!blockEntity.checkDespawnConditions()) {
            return;
        }
        log.debug("Despawn tick for {}", (Object)blockEntity);
        Set<EasyNPC<?>> validEasyNPCs = blockEntity.getEasyNPCsInRange(blockEntity.worldPosition, blockEntity.despawnRange);
        Set<EasyNPC<?>> nearbyEasyNPCs = blockEntity.getEasyNPCsInRange(blockEntity.worldPosition, blockEntity.despawnRange + 256);
        for (EasyNPC<?> easyNPC : nearbyEasyNPCs) {
            if (validEasyNPCs.contains(easyNPC)) continue;
            log.debug("Despawn {} from spawner at {} outside of range {}", easyNPC, (Object)blockPos, (Object)blockEntity.despawnRange);
            easyNPC.getEntity().discard();
        }
    }

    public static void spawnTick(Level level, BlockPos blockPos, BlockState blockState, BaseEasyNPCSpawnerBlockEntity blockEntity) {
        if (!blockEntity.checkSpawnConditions()) {
            return;
        }
        log.debug("Spawn tick for {}", (Object)blockEntity);
        BlockPos spawnerBlockPos = BaseEasyNPCSpawnerBlockEntity.getFreeSpawnerBlockPos(blockPos, level);
        ItemStack presetItemStack = blockEntity.getPresetItemStack().copy();
        EasyNPCPresetItem.setSpawnerUUID(presetItemStack, blockEntity.getSpawnerUUID());
        int numbersPerSpawnInterval = blockEntity.getSpawnCount();
        Iterable possibleSpawnPositions = BlockPos.spiralAround((BlockPos)spawnerBlockPos, (int)blockEntity.getSpawnRange(), (Direction)Direction.NORTH, (Direction)Direction.EAST);
        for (BlockPos.MutableBlockPos spawnBlockPos : possibleSpawnPositions) {
            AABB aabb = new AABB((BlockPos)spawnBlockPos).inflate(0.1);
            BlockPos targetBlockPos = new BlockPos(spawnBlockPos.getX(), spawnBlockPos.getY(), spawnBlockPos.getZ());
            if (!level.getBlockState(targetBlockPos.above()).isAir() || level.getBlockState(targetBlockPos).getBlock() instanceof BaseEasyNPCSpawnerBlock || !level.getEntitiesOfClass(LivingEntity.class, aabb).isEmpty() || !EasyNPCPresetItem.spawnAtPosition((BlockPos)spawnBlockPos, presetItemStack, level)) continue;
            if (blockEntity.getSpawnCount() > 0) {
                if (--numbersPerSpawnInterval <= 0) break;
                log.info("Spawned {} ({} / {}) at {} with in {}", (Object)presetItemStack, (Object)numbersPerSpawnInterval, (Object)blockEntity.getSpawnCount(), (Object)spawnBlockPos, (Object)level);
                continue;
            }
            log.info("Spawned {} at {} with in {}", (Object)presetItemStack, (Object)spawnBlockPos, (Object)level);
        }
    }

    public static BlockPos getFreeSpawnerBlockPos(BlockPos blockPos, Level level) {
        for (int yExpand = 0; yExpand < 3; ++yExpand) {
            if (!level.getBlockState(blockPos.above(yExpand).north()).isAir() && !level.getBlockState(blockPos.above(yExpand).south()).isAir() && !level.getBlockState(blockPos.above(yExpand).east()).isAir() && !level.getBlockState(blockPos.above(yExpand).west()).isAir()) continue;
            return blockPos.above(yExpand);
        }
        return blockPos;
    }

    public boolean checkDespawnConditions() {
        Level level;
        if (this.getPresetItemStack() == null) {
            return false;
        }
        if (this.despawnRange > 0 && (level = this.getLevel()) != null) {
            Set<EasyNPC<?>> validEasyNPCs = this.getEasyNPCsInRange(this.worldPosition, this.despawnRange);
            Set<EasyNPC<?>> nearbyEasyNPCs = this.getEasyNPCsInRange(this.worldPosition, this.despawnRange + 256);
            for (EasyNPC<?> easyNPC : nearbyEasyNPCs) {
                if (validEasyNPCs.contains(easyNPC)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean checkSpawnConditions() {
        Level level;
        if (this.getPresetItemStack() == null) {
            return false;
        }
        if (this.requiredPlayerRange > 0 && (level = this.getLevel()) != null) {
            boolean isPlayerInRange = false;
            for (Player player : level.players()) {
                if (!(player.distanceToSqr((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ()) <= (double)(this.requiredPlayerRange * this.requiredPlayerRange))) continue;
                isPlayerInRange = true;
                break;
            }
            if (!isPlayerInRange) {
                return false;
            }
        }
        if (this.maxNearbyEntities > 0) {
            Set<EasyNPC<?>> nearbyEasyNPCs = this.getEasyNPCsInRange(this.worldPosition, this.spawnRange);
            return nearbyEasyNPCs.size() < this.maxNearbyEntities;
        }
        return true;
    }

    public ItemStack getPresetItemStack() {
        if (this.items.isEmpty() || ((ItemStack)this.items.getFirst()).isEmpty() && !EasyNPCPresetItem.hasPreset((ItemStack)this.items.getFirst())) {
            return null;
        }
        return (ItemStack)this.items.getFirst();
    }

    public UUID getSpawnerUUID() {
        return this.spawnerUUID;
    }

    public void setSpawnerUUID(UUID spawnerUUID) {
        this.spawnerUUID = spawnerUUID;
        this.setChanged();
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(LivingEntity livingEntity) {
        this.owner = livingEntity.getUUID();
        this.setChanged();
    }

    protected Component getDefaultName() {
        return TextComponent.getTranslatedTextRaw("text.easy_npc.container.easy_npc_spawner_entity");
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    protected AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return null;
    }

    public int getSpawnRange() {
        return this.dataAccess.get(3);
    }

    public void setSpawnRange(int spawnRange) {
        this.dataAccess.set(3, Math.clamp((long)spawnRange, 0, 64));
        this.setChanged();
    }

    public int getDespawnRange() {
        return this.dataAccess.get(8);
    }

    public void setDespawnRange(int despawnRange) {
        this.dataAccess.set(8, Math.clamp((long)despawnRange, 0, 128));
        this.setChanged();
    }

    public int getRequiredPlayerRange() {
        return this.dataAccess.get(4);
    }

    public void setRequiredPlayerRange(int requiredPlayerRange) {
        this.dataAccess.set(4, Math.clamp((long)requiredPlayerRange, 0, 64));
        this.setChanged();
    }

    public int getDelay() {
        return this.dataAccess.get(5);
    }

    public void setDelay(int delay) {
        this.dataAccess.set(5, Math.clamp((long)delay, 0, 3600));
        this.setChanged();
    }

    public int getMaxNearbyEntities() {
        return this.dataAccess.get(6);
    }

    public void setMaxNearbyEntities(int maxNearbyEntities) {
        this.dataAccess.set(6, Math.clamp((long)maxNearbyEntities, 0, 256));
        this.setChanged();
    }

    public int getSpawnCount() {
        return this.dataAccess.get(7);
    }

    public void setSpawnCount(int spawnCount) {
        this.dataAccess.set(7, Math.clamp((long)spawnCount, 0, 32));
        this.setChanged();
    }

    public Set<EasyNPC<?>> getEasyNPCsInRange(BlockPos blockPos, int range) {
        if (this.level == null) {
            return new HashSet();
        }
        HashSet foundEasyNPCs = new HashSet();
        AABB aabb = new AABB(blockPos).inflate((double)range);
        for (LivingEntity livingEntity : this.level.getEntitiesOfClass(LivingEntity.class, aabb)) {
            EasyNPC easyNPC;
            if (!(livingEntity instanceof EasyNPC) || !(easyNPC = (EasyNPC)livingEntity).getEasyNPCSpawnerData().hasSpawnerUUID() || !easyNPC.getEasyNPCSpawnerData().getSpawnerUUID().equals(this.spawnerUUID)) continue;
            foundEasyNPCs.add(easyNPC);
        }
        return foundEasyNPCs;
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemStack : this.items) {
            if (itemStack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack removeItem(int index, int count) {
        return ContainerHelper.removeItem(this.items, (int)index, (int)count);
    }

    public ItemStack removeItemNoUpdate(int index) {
        return ContainerHelper.takeItem(this.items, (int)index);
    }

    public void setItem(int index, ItemStack itemStack) {
        ItemStack itemStackFromIndex = (ItemStack)this.items.get(index);
        if (itemStack.is(itemStackFromIndex.getItem())) {
            return;
        }
        this.items.set(index, (Object)itemStack);
    }

    public boolean stillValid(Player player) {
        Level level = this.level;
        return level != null && level.getBlockEntity(this.worldPosition) == this && player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    public void clearContent() {
        this.items.clear();
    }

    public void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.spawnerUUID = compoundTag.getUUID(UUID_TAG);
        this.owner = compoundTag.getUUID(SPAWNER_OWNER_TAG);
        this.spawnRange = compoundTag.getInt(SPAWN_RANGE_TAG);
        this.despawnRange = compoundTag.getInt(DESPAWN_RANGE_TAG);
        this.requiredPlayerRange = compoundTag.getInt(REQUIRED_PLAYER_RANGE_TAG);
        this.delay = compoundTag.getInt(DELAY_TAG);
        this.maxNearbyEntities = compoundTag.getInt(MAX_NEARBY_ENTITIES_TAG);
        this.numbersPerSpawnInterval = compoundTag.getInt(SPAWN_COUNT_TAG);
        this.items.clear();
        ContainerHelper.loadAllItems((CompoundTag)compoundTag, this.items, (HolderLookup.Provider)provider);
    }

    public void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.putUUID(UUID_TAG, Objects.requireNonNullElseGet(this.spawnerUUID, UUID::randomUUID));
        if (this.owner != null) {
            compoundTag.putUUID(SPAWNER_OWNER_TAG, this.owner);
        }
        compoundTag.putInt(SPAWN_RANGE_TAG, this.spawnRange);
        compoundTag.putInt(DESPAWN_RANGE_TAG, this.despawnRange);
        compoundTag.putInt(REQUIRED_PLAYER_RANGE_TAG, this.requiredPlayerRange);
        compoundTag.putInt(DELAY_TAG, this.delay);
        compoundTag.putInt(MAX_NEARBY_ENTITIES_TAG, this.maxNearbyEntities);
        compoundTag.putInt(SPAWN_COUNT_TAG, this.numbersPerSpawnInterval);
        ContainerHelper.saveAllItems((CompoundTag)compoundTag, this.items, (HolderLookup.Provider)provider);
    }
}

