/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model.standard;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.client.model.base.BaseHierarchicalArmLegsModel;
import de.markusbordihn.easynpc.entity.easynpc.data.AttackData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Mob;

public class StandardIronGolemModel<T extends Mob>
extends BaseHierarchicalArmLegsModel<T> {
    public StandardIronGolemModel(ModelPart modelPart) {
        super(modelPart);
    }

    @Override
    public boolean animateModelLegs(T entity, AttackData<?> attackData, ModelData<?> modelData, ModelPart rightLegPart, ModelPart leftLegPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        if (rightLegPart == null && leftLegPart == null) {
            return false;
        }
        this.rightLeg.xRot = -1.5f * Mth.triangleWave((float)limbSwing, (float)13.0f) * limbSwingAmount;
        this.leftLeg.xRot = 1.5f * Mth.triangleWave((float)limbSwing, (float)13.0f) * limbSwingAmount;
        this.rightLeg.yRot = 0.0f;
        this.leftLeg.yRot = 0.0f;
        return true;
    }

    @Override
    public void animateAttackModelPose(T entity, AttackData<?> attackData, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        int attackAnimationTick = attackData.getAttackAnimationTick();
        if (attackAnimationTick > 0) {
            this.rightArm.xRot = -2.0f + 1.5f * Mth.triangleWave((float)attackAnimationTick, (float)10.0f);
            this.leftArm.xRot = -2.0f + 1.5f * Mth.triangleWave((float)attackAnimationTick, (float)10.0f);
        } else {
            this.rightArm.xRot = (-0.2f + 1.5f * Mth.triangleWave((float)limbSwing, (float)13.0f)) * limbSwingAmount;
            this.leftArm.xRot = (-0.2f - 1.5f * Mth.triangleWave((float)limbSwing, (float)13.0f)) * limbSwingAmount;
        }
    }

    @Override
    public void translateToHand(HumanoidArm humanoidArm, PoseStack poseStack) {
        ModelPart modelpart = this.getArm(humanoidArm);
        modelpart.translateAndRotate(poseStack);
        poseStack.translate(humanoidArm == HumanoidArm.RIGHT ? -0.64f : 0.64f, 0.9f, 0.0f);
    }
}

