/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class HeldItemLayer<E extends LivingEntity, M extends EntityModel<E>>
extends RenderLayer<E, M> {
    private final ItemInHandRenderer itemInHandRenderer;
    private double offsetX = 0.06;
    private double offsetY = 0.15;
    private double offsetZ = -0.52;

    public HeldItemLayer(RenderLayerParent<E, M> renderer, ItemInHandRenderer itemInHandRenderer, double offsetX, double offsetY, double offsetZ) {
        this(renderer, itemInHandRenderer);
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
    }

    public HeldItemLayer(RenderLayerParent<E, M> renderer, ItemInHandRenderer itemInHandRenderer) {
        super(renderer);
        this.itemInHandRenderer = itemInHandRenderer;
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int lightLevel, E entity, float limbSwing, float limbSwingAmount, float ageInTicks, float ageInTicks2, float netHeadYaw, float headPitch) {
        ModelPart head = ((HeadedModel)this.getParentModel()).getHead();
        poseStack.pushPose();
        poseStack.translate(head.x / 16.0f, head.y / 16.0f, head.z / 16.0f);
        poseStack.mulPose(Axis.ZP.rotation(0.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(netHeadYaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(headPitch));
        poseStack.translate(this.offsetX, this.offsetY, this.offsetZ);
        poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        ItemStack itemStack = entity.getItemBySlot(EquipmentSlot.MAINHAND);
        this.itemInHandRenderer.renderItem(entity, itemStack, ItemDisplayContext.GROUND, false, poseStack, buffer, lightLevel);
        poseStack.popPose();
    }
}

