/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.standard;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.markusbordihn.easynpc.client.model.base.BasePlayerModel;
import de.markusbordihn.easynpc.client.renderer.EasyNPCModelRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.base.BaseLivingEntityModelRenderer;
import de.markusbordihn.easynpc.entity.easynpc.npc.HumanoidSlim;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;

public class HumanoidSlimModelRenderer
extends BaseLivingEntityModelRenderer<HumanoidSlim, HumanoidSlim.Variant, BasePlayerModel<HumanoidSlim>> {
    protected static final Map<HumanoidSlim.Variant, ResourceLocation> TEXTURE_BY_VARIANT = (Map)Util.make(new EnumMap(HumanoidSlim.Variant.class), map -> {
        map.put(HumanoidSlim.Variant.ALEX, ResourceLocation.withDefaultNamespace((String)"textures/entity/player/slim/alex.png"));
        map.put(HumanoidSlim.Variant.ARI, ResourceLocation.withDefaultNamespace((String)"textures/entity/player/slim/ari.png"));
        map.put(HumanoidSlim.Variant.EFE, ResourceLocation.withDefaultNamespace((String)"textures/entity/player/slim/efe.png"));
        map.put(HumanoidSlim.Variant.KAI, ResourceLocation.withDefaultNamespace((String)"textures/entity/player/slim/kai.png"));
        map.put(HumanoidSlim.Variant.MAKENA, ResourceLocation.withDefaultNamespace((String)"textures/entity/player/slim/makena.png"));
        map.put(HumanoidSlim.Variant.NOOR, ResourceLocation.withDefaultNamespace((String)"textures/entity/player/slim/noor.png"));
        map.put(HumanoidSlim.Variant.STEVE, ResourceLocation.withDefaultNamespace((String)"textures/entity/player/slim/steve.png"));
        map.put(HumanoidSlim.Variant.SUNNY, ResourceLocation.withDefaultNamespace((String)"textures/entity/player/slim/sunny.png"));
        map.put(HumanoidSlim.Variant.ZURI, ResourceLocation.withDefaultNamespace((String)"textures/entity/player/slim/zuri.png"));
        map.put(HumanoidSlim.Variant.KAWORRU, ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"textures/entity/humanoid_slim/kaworru.png"));
    });
    protected static final ResourceLocation DEFAULT_TEXTURE = TEXTURE_BY_VARIANT.get((Object)HumanoidSlim.Variant.ALEX);

    public <L extends RenderLayer<HumanoidSlim, BasePlayerModel<HumanoidSlim>>> HumanoidSlimModelRenderer(EntityRendererProvider.Context context, Class<L> humanoidArmorLayerClass) {
        super(context, new BasePlayerModel(context.bakeLayer(ModelLayers.PLAYER_SLIM), true), 0.5f, DEFAULT_TEXTURE, TEXTURE_BY_VARIANT);
        this.addLayer((RenderLayer)EasyNPCModelRenderer.getHumanoidArmorLayer(this, context, ModelLayers.PLAYER_SLIM_INNER_ARMOR, ModelLayers.PLAYER_SLIM_OUTER_ARMOR, humanoidArmorLayerClass));
        this.addLayer((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.getModelSet(), context.getItemInHandRenderer()));
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.getItemInHandRenderer()));
        this.addLayer((RenderLayer)new ElytraLayer((RenderLayerParent)this, context.getModelSet()));
    }

    @Override
    public ResourceLocation getTextureLocation(HumanoidSlim entity) {
        return this.getEntityPlayerTexture(entity);
    }

    @Override
    public void renderDefaultPose(HumanoidSlim entity, BasePlayerModel<HumanoidSlim> model, Pose pose, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        switch (pose) {
            case DYING: {
                poseStack.translate(-1.0, 0.0, 0.0);
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                poseStack.mulPose(Axis.ZP.rotationDegrees(this.getFlipDegrees((LivingEntity)entity)));
                poseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
                model.getHead().xRot = -0.7853982f;
                model.getHead().yRot = -0.7853982f;
                model.getHead().zRot = -0.7853982f;
                break;
            }
            case LONG_JUMPING: {
                model.leftArmPose = HumanoidModel.ArmPose.CROSSBOW_HOLD;
                model.rightArmPose = HumanoidModel.ArmPose.SPYGLASS;
                break;
            }
            case SLEEPING: {
                poseStack.translate(1.0, 0.0, 0.0);
                break;
            }
            case SPIN_ATTACK: {
                model.leftArmPose = HumanoidModel.ArmPose.BLOCK;
                model.rightArmPose = HumanoidModel.ArmPose.THROW_SPEAR;
                poseStack.mulPose(Axis.YP.rotationDegrees(-35.0f));
                break;
            }
            default: {
                model.leftArmPose = HumanoidModel.ArmPose.EMPTY;
                model.rightArmPose = HumanoidModel.ArmPose.EMPTY;
                model.getHead().xRot = 0.0f;
                model.getHead().yRot = 0.0f;
                model.getHead().zRot = 0.0f;
            }
        }
    }
}

