/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.standard;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.markusbordihn.easynpc.client.model.standard.StandardIllagerModel;
import de.markusbordihn.easynpc.client.renderer.entity.base.BaseMobModelRenderer;
import de.markusbordihn.easynpc.entity.easynpc.npc.Illager;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;

public class IllagerModelRenderer
extends BaseMobModelRenderer<Illager, Illager.Variant, StandardIllagerModel<Illager>> {
    protected static final Map<Illager.Variant, ResourceLocation> TEXTURE_BY_VARIANT = (Map)Util.make(new EnumMap(Illager.Variant.class), map -> {
        map.put(Illager.Variant.EVOKER, ResourceLocation.withDefaultNamespace((String)"textures/entity/illager/evoker.png"));
        map.put(Illager.Variant.EVOKER_CROSSED_ARMS, ResourceLocation.withDefaultNamespace((String)"textures/entity/illager/evoker.png"));
        map.put(Illager.Variant.ILLUSIONER, ResourceLocation.withDefaultNamespace((String)"textures/entity/illager/illusioner.png"));
        map.put(Illager.Variant.ILLUSIONER_CROSSED_ARMS, ResourceLocation.withDefaultNamespace((String)"textures/entity/illager/illusioner.png"));
        map.put(Illager.Variant.PILLAGER, ResourceLocation.withDefaultNamespace((String)"textures/entity/illager/pillager.png"));
        map.put(Illager.Variant.VINDICATOR, ResourceLocation.withDefaultNamespace((String)"textures/entity/illager/vindicator.png"));
        map.put(Illager.Variant.VINDICATOR_CROSSED_ARMS, ResourceLocation.withDefaultNamespace((String)"textures/entity/illager/vindicator.png"));
    });
    protected static final ResourceLocation DEFAULT_TEXTURE = TEXTURE_BY_VARIANT.get((Object)Illager.Variant.PILLAGER);

    public <L extends RenderLayer<Illager, StandardIllagerModel<Illager>>> IllagerModelRenderer(EntityRendererProvider.Context context) {
        super(context, new StandardIllagerModel(context.bakeLayer(ModelLayers.PILLAGER)), 0.5f, DEFAULT_TEXTURE, TEXTURE_BY_VARIANT);
        this.addLayer((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.getModelSet(), context.getItemInHandRenderer()));
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.getItemInHandRenderer()));
    }

    @Override
    public void renderDefaultPose(Illager entity, StandardIllagerModel<Illager> model, Pose pose, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        switch (pose) {
            case DYING: {
                poseStack.translate(-1.0, 0.0, 0.0);
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                poseStack.mulPose(Axis.ZP.rotationDegrees(this.getFlipDegrees((LivingEntity)entity)));
                poseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
                model.getHead().xRot = -0.7853982f;
                model.getHead().yRot = -0.7853982f;
                model.getHead().zRot = -0.7853982f;
                break;
            }
            case SLEEPING: {
                poseStack.translate(1.0, 0.0, 0.0);
                break;
            }
            default: {
                model.getHead().xRot = 0.0f;
                model.getHead().yRot = 0.0f;
                model.getHead().zRot = 0.0f;
            }
        }
    }
}

