/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.standard;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.model.standard.StandardVillagerModel;
import de.markusbordihn.easynpc.client.renderer.entity.base.BaseMobModelRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.layers.ProfessionLayer;
import de.markusbordihn.easynpc.client.renderer.entity.layers.VariantLayer;
import de.markusbordihn.easynpc.data.profession.Profession;
import de.markusbordihn.easynpc.entity.easynpc.npc.Villager;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CrossedArmsItemLayer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;

public class VillagerModelRenderer
extends BaseMobModelRenderer<Villager, Villager.Variant, StandardVillagerModel<Villager>> {
    public static final ResourceLocation BASE_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/entity/villager/villager.png");
    protected static final Map<Profession, ResourceLocation> TEXTURE_BY_PROFESSION = (Map)Util.make(new EnumMap(Profession.class), map -> {
        map.put(Profession.NONE, Constants.BLANK_ENTITY_TEXTURE);
        map.put(Profession.ARMORER, ResourceLocation.withDefaultNamespace((String)"textures/entity/villager/profession/armorer.png"));
        map.put(Profession.BUTCHER, ResourceLocation.withDefaultNamespace((String)"textures/entity/villager/profession/butcher.png"));
        map.put(Profession.CARTOGRAPHER, ResourceLocation.withDefaultNamespace((String)"textures/entity/villager/profession/cartographer.png"));
        map.put(Profession.CLERIC, ResourceLocation.withDefaultNamespace((String)"textures/entity/villager/profession/cleric.png"));
        map.put(Profession.FARMER, ResourceLocation.withDefaultNamespace((String)"textures/entity/villager/profession/farmer.png"));
        map.put(Profession.FISHERMAN, ResourceLocation.withDefaultNamespace((String)"textures/entity/villager/profession/fisherman.png"));
        map.put(Profession.FLETCHER, ResourceLocation.withDefaultNamespace((String)"textures/entity/villager/profession/fletcher.png"));
        map.put(Profession.LEATHERWORKER, ResourceLocation.withDefaultNamespace((String)"textures/entity/villager/profession/leatherworker.png"));
        map.put(Profession.LIBRARIAN, ResourceLocation.withDefaultNamespace((String)"textures/entity/villager/profession/librarian.png"));
        map.put(Profession.MASON, ResourceLocation.withDefaultNamespace((String)"textures/entity/villager/profession/mason.png"));
        map.put(Profession.NITWIT, ResourceLocation.withDefaultNamespace((String)"textures/entity/villager/profession/nitwit.png"));
        map.put(Profession.SHEPHERD, ResourceLocation.withDefaultNamespace((String)"textures/entity/villager/profession/shepherd.png"));
        map.put(Profession.TOOLSMITH, ResourceLocation.withDefaultNamespace((String)"textures/entity/villager/profession/toolsmith.png"));
        map.put(Profession.WEAPONSMITH, ResourceLocation.withDefaultNamespace((String)"textures/entity/villager/profession/weaponsmith.png"));
    });
    protected static final Map<Villager.Variant, ResourceLocation> TEXTURE_BY_VARIANT = (Map)Util.make(new EnumMap(Villager.Variant.class), map -> {
        map.put(Villager.Variant.DEFAULT, Constants.BLANK_ENTITY_TEXTURE);
        map.put(Villager.Variant.DESERT, ResourceLocation.withDefaultNamespace((String)"textures/entity/villager/type/desert.png"));
        map.put(Villager.Variant.JUNGLE, ResourceLocation.withDefaultNamespace((String)"textures/entity/villager/type/jungle.png"));
        map.put(Villager.Variant.PLAINS, ResourceLocation.withDefaultNamespace((String)"textures/entity/villager/type/plains.png"));
        map.put(Villager.Variant.SAVANNA, ResourceLocation.withDefaultNamespace((String)"textures/entity/villager/type/savanna.png"));
        map.put(Villager.Variant.SNOW, ResourceLocation.withDefaultNamespace((String)"textures/entity/villager/type/snow.png"));
        map.put(Villager.Variant.SWAMP, ResourceLocation.withDefaultNamespace((String)"textures/entity/villager/type/swamp.png"));
        map.put(Villager.Variant.TAIGA, ResourceLocation.withDefaultNamespace((String)"textures/entity/villager/type/taiga.png"));
    });

    public VillagerModelRenderer(EntityRendererProvider.Context context) {
        super(context, new StandardVillagerModel(context.bakeLayer(ModelLayers.VILLAGER)), 0.5f, BASE_TEXTURE);
        this.addLayer(new VariantLayer(this, context.getModelSet(), TEXTURE_BY_VARIANT));
        this.addLayer((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.getModelSet(), context.getItemInHandRenderer()));
        this.addLayer(new ProfessionLayer(this, context.getModelSet(), TEXTURE_BY_PROFESSION));
        this.addLayer((RenderLayer)new CrossedArmsItemLayer((RenderLayerParent)this, context.getItemInHandRenderer()));
    }

    @Override
    public ResourceLocation getTextureByVariant(Enum<?> variant) {
        return BASE_TEXTURE;
    }

    @Override
    public void renderDefaultPose(Villager entity, StandardVillagerModel<Villager> model, Pose pose, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        switch (pose) {
            case DYING: {
                poseStack.translate(-1.0, 0.0, 0.0);
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                poseStack.mulPose(Axis.ZP.rotationDegrees(this.getFlipDegrees((LivingEntity)entity)));
                poseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
                ((StandardVillagerModel)this.getModel()).getHead().xRot = -0.7853982f;
                ((StandardVillagerModel)this.getModel()).getHead().yRot = -0.7853982f;
                ((StandardVillagerModel)this.getModel()).getHead().zRot = -0.7853982f;
                break;
            }
            case SLEEPING: {
                poseStack.translate(1.0, 0.0, 0.0);
                break;
            }
            default: {
                ((StandardVillagerModel)this.getModel()).getHead().xRot = 0.0f;
                ((StandardVillagerModel)this.getModel()).getHead().yRot = 0.0f;
                ((StandardVillagerModel)this.getModel()).getHead().zRot = 0.0f;
            }
        }
    }
}

