/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.standard;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.markusbordihn.easynpc.client.model.standard.StandardZombieModel;
import de.markusbordihn.easynpc.client.renderer.EasyNPCModelRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.base.BaseHumanoidMobModelRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.layers.OuterLayer;
import de.markusbordihn.easynpc.entity.easynpc.npc.Zombie;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;

public class ZombieModelRenderer
extends BaseHumanoidMobModelRenderer<Zombie, Zombie.Variant, StandardZombieModel<Zombie>> {
    protected static final Map<Zombie.Variant, ResourceLocation> TEXTURE_BY_VARIANT = (Map)Util.make(new EnumMap(Zombie.Variant.class), map -> {
        map.put(Zombie.Variant.DROWNED, ResourceLocation.withDefaultNamespace((String)"textures/entity/zombie/drowned.png"));
        map.put(Zombie.Variant.HUSK, ResourceLocation.withDefaultNamespace((String)"textures/entity/zombie/husk.png"));
        map.put(Zombie.Variant.ZOMBIE, ResourceLocation.withDefaultNamespace((String)"textures/entity/zombie/zombie.png"));
    });
    protected static final Map<Zombie.Variant, ResourceLocation> OUTER_TEXTURE_BY_VARIANT = (Map)Util.make(new EnumMap(Zombie.Variant.class), map -> map.put(Zombie.Variant.DROWNED, ResourceLocation.withDefaultNamespace((String)"textures/entity/zombie/drowned_outer_layer.png")));
    protected static final ResourceLocation DEFAULT_TEXTURE = TEXTURE_BY_VARIANT.get((Object)Zombie.Variant.ZOMBIE);

    public <T extends RenderLayer<Zombie, StandardZombieModel<Zombie>>> ZombieModelRenderer(EntityRendererProvider.Context context, Class<T> humanoidArmorLayerClass) {
        super(context, new StandardZombieModel(context.bakeLayer(ModelLayers.ZOMBIE)), 0.5f, DEFAULT_TEXTURE, TEXTURE_BY_VARIANT);
        this.addLayer((RenderLayer)EasyNPCModelRenderer.getHumanoidArmorLayer(this, context, ModelLayers.ZOMBIE_INNER_ARMOR, ModelLayers.ZOMBIE_OUTER_ARMOR, humanoidArmorLayerClass));
        this.addLayer((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.getModelSet(), context.getItemInHandRenderer()));
        this.addLayer(new OuterLayer(this, context.getModelSet(), OUTER_TEXTURE_BY_VARIANT));
        this.addLayer((RenderLayer)new ElytraLayer((RenderLayerParent)this, context.getModelSet()));
    }

    @Override
    public void renderDefaultPose(Zombie entity, StandardZombieModel<Zombie> playerModel, Pose pose, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        switch (pose) {
            case DYING: {
                poseStack.translate(-1.0, 0.0, 0.0);
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                poseStack.mulPose(Axis.ZP.rotationDegrees(this.getFlipDegrees((LivingEntity)entity)));
                poseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
                playerModel.getHead().xRot = -0.7853982f;
                playerModel.getHead().yRot = -0.7853982f;
                playerModel.getHead().zRot = -0.7853982f;
                break;
            }
            case LONG_JUMPING: {
                playerModel.leftArmPose = HumanoidModel.ArmPose.CROSSBOW_HOLD;
                playerModel.rightArmPose = HumanoidModel.ArmPose.SPYGLASS;
                break;
            }
            case SLEEPING: {
                poseStack.translate(1.0, 0.0, 0.0);
                break;
            }
            case SPIN_ATTACK: {
                playerModel.leftArmPose = HumanoidModel.ArmPose.BLOCK;
                playerModel.rightArmPose = HumanoidModel.ArmPose.THROW_SPEAR;
                poseStack.mulPose(Axis.YP.rotationDegrees(-35.0f));
                break;
            }
            default: {
                playerModel.leftArmPose = HumanoidModel.ArmPose.EMPTY;
                playerModel.rightArmPose = HumanoidModel.ArmPose.EMPTY;
                playerModel.getHead().xRot = 0.0f;
                playerModel.getHead().yRot = 0.0f;
                playerModel.getHead().zRot = 0.0f;
            }
        }
    }
}

