/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.preset;

import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.client.screen.configuration.preset.ExportPresetConfigurationScreen;
import de.markusbordihn.easynpc.io.CustomPresetDataFiles;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;

public class ExportWorldPresetConfigurationScreen<T extends ConfigurationMenu>
extends ExportPresetConfigurationScreen<T> {
    protected Button exportPresetButton;
    protected int numberOfTextLines = 1;
    private EditBox nameBox;
    private List<FormattedCharSequence> textComponents = Collections.emptyList();

    public ExportWorldPresetConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    private void validateName() {
        this.exportPresetButton.active = !this.nameBox.getValue().isEmpty();
    }

    @Override
    public void init() {
        super.init();
        this.worldExportPresetButton.active = false;
        File customPresetFile = CustomPresetDataFiles.getPresetFile(this.getSkinModel(), this.getEasyNPCUUID());
        String customPresetFileName = customPresetFile.getName();
        this.nameBox = new TextField(this.font, this.contentLeftPos + 5, this.bottomPos - 65, 270);
        this.nameBox.setMaxLength(64);
        this.nameBox.setValue(customPresetFileName);
        this.nameBox.setResponder(consumer -> this.validateName());
        this.addRenderableWidget((GuiEventListener)this.nameBox);
        this.textComponents = this.font.split((FormattedText)TextComponent.getTranslatedConfigText("export_preset_world_text", customPresetFile.getParentFile().getPath(), customPresetFile.getName()), this.imageWidth - 25);
        this.numberOfTextLines = this.textComponents.size();
        this.exportPresetButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.contentLeftPos + 65, this.bottomPos - 40, 150, "export", button -> {
            NetworkMessageHandlerManager.getServerHandler().exportWorldPreset(this.getEasyNPCUUID(), this.nameBox.getValue());
            this.exportPresetButton.active = false;
        }));
    }

    @Override
    public void render(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.render(guiGraphics, x, y, partialTicks);
        if (!this.textComponents.isEmpty()) {
            for (int line = 0; line < this.numberOfTextLines; ++line) {
                FormattedCharSequence formattedCharSequence = this.textComponents.get(line);
                Objects.requireNonNull(this.font);
                Text.drawString(guiGraphics, this.font, formattedCharSequence, this.leftPos + 15, this.topPos + 80 + line * (9 + 2));
            }
        }
    }
}

