/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.rotation;

import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.SliderButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.configuration.rotation.RotationConfigurationScreen;
import de.markusbordihn.easynpc.data.model.ModelPart;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.network.components.TextComponent;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class DefaultRotationConfigurationScreen<T extends ConfigurationMenu>
extends RotationConfigurationScreen<T> {
    protected Button rootRotationXResetButton;
    protected Button rootRotationYResetButton;
    protected Button rootRotationZResetButton;
    protected SliderButton rootRotationXSliderButton;
    protected SliderButton rootRotationYSliderButton;
    protected SliderButton rootRotationZSliderButton;
    protected Checkbox rootRotationCheckbox;
    protected float rootRotationX = 0.0f;
    protected float rootRotationY = 0.0f;
    protected float rootRotationZ = 0.0f;

    public DefaultRotationConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
        this.showCloseButton = true;
        this.renderBackground = false;
    }

    @Override
    public void init() {
        super.init();
        this.defaultRotationButton.active = false;
        ModelData<?> modelData = this.getEasyNPC().getEasyNPCModelData();
        CustomRotation rootRotation = modelData.getModelRootRotation();
        this.rootRotationX = rootRotation.x();
        this.rootRotationY = rootRotation.y();
        this.rootRotationZ = rootRotation.z();
        this.rootRotationXSliderButton = (SliderButton)this.addRenderableWidget((GuiEventListener)new SliderButton(this.contentLeftPos, this.contentTopPos, 60, "rootRotationX", (float)Math.toDegrees(rootRotation.x()), SliderButton.Type.DEGREE, slider -> {
            this.rootRotationX = (float)Math.toRadians(slider.getTargetValue());
            NetworkMessageHandlerManager.getServerHandler().rotationChange(this.getEasyNPCUUID(), ModelPart.ROOT, new CustomRotation(this.rootRotationX, this.rootRotationY, this.rootRotationZ));
        }));
        this.rootRotationXResetButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.rootRotationXSliderButton.getX() + this.rootRotationXSliderButton.getWidth(), this.contentTopPos, 10, (Component)TextComponent.getText("\u21ba"), button -> {
            this.rootRotationX = 0.0f;
            this.rootRotationXSliderButton.reset();
        }));
        this.rootRotationYSliderButton = (SliderButton)this.addRenderableWidget((GuiEventListener)new SliderButton(this.rootRotationXResetButton.getX() + this.rootRotationXResetButton.getWidth() + 5, this.contentTopPos, 60, "rootRotationY", (float)Math.toDegrees(rootRotation.y()), SliderButton.Type.DEGREE, slider -> {
            this.rootRotationY = (float)Math.toRadians(slider.getTargetValue());
            NetworkMessageHandlerManager.getServerHandler().rotationChange(this.getEasyNPCUUID(), ModelPart.ROOT, new CustomRotation(this.rootRotationX, this.rootRotationY, this.rootRotationZ));
        }));
        this.rootRotationYResetButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.rootRotationYSliderButton.getX() + this.rootRotationYSliderButton.getWidth(), this.contentTopPos, 10, (Component)TextComponent.getText("\u21ba"), button -> {
            this.rootRotationY = 0.0f;
            this.rootRotationYSliderButton.reset();
        }));
        this.rootRotationZSliderButton = (SliderButton)this.addRenderableWidget((GuiEventListener)new SliderButton(this.rootRotationYResetButton.getX() + this.rootRotationYResetButton.getWidth() + 5, this.contentTopPos, 60, "rootRotationZ", (float)Math.toDegrees(rootRotation.z()), SliderButton.Type.DEGREE, slider -> {
            this.rootRotationZ = (float)Math.toRadians(slider.getTargetValue());
            NetworkMessageHandlerManager.getServerHandler().rotationChange(this.getEasyNPCUUID(), ModelPart.ROOT, new CustomRotation(this.rootRotationX, this.rootRotationY, this.rootRotationZ));
        }));
        this.rootRotationZResetButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.rootRotationZSliderButton.getX() + this.rootRotationZSliderButton.getWidth(), this.contentTopPos, 10, (Component)TextComponent.getText("\u21ba"), button -> {
            this.rootRotationZ = 0.0f;
            this.rootRotationZSliderButton.reset();
        }));
        this.rootRotationCheckbox = (Checkbox)this.addRenderableWidget((GuiEventListener)new Checkbox(this.rootRotationZResetButton.getX() + this.rootRotationZResetButton.getWidth() + 5, this.contentTopPos + 2, "lock_rotation", modelData.getModelLockRotation(), checkbox -> NetworkMessageHandlerManager.getServerHandler().modelLockRotationChange(this.getEasyNPCUUID(), checkbox.selected())));
    }

    @Override
    public void render(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.render(guiGraphics, x, y, partialTicks);
        if (this.rootRotationXSliderButton != null) {
            Text.drawString(guiGraphics, this.font, "Rotation X", this.rootRotationXSliderButton.getX() + 5, this.rootRotationXSliderButton.getY() + 25);
        }
        if (this.rootRotationYSliderButton != null) {
            Text.drawString(guiGraphics, this.font, "Rotation Y", this.rootRotationYSliderButton.getX() + 5, this.rootRotationYSliderButton.getY() + 25);
        }
        if (this.rootRotationZSliderButton != null) {
            Text.drawString(guiGraphics, this.font, "Rotation Z", this.rootRotationZSliderButton.getX() + 5, this.rootRotationZSliderButton.getY() + 25);
        }
    }
}

