/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.skin;

import de.markusbordihn.easynpc.client.screen.components.ReloadButton;
import de.markusbordihn.easynpc.client.screen.components.SearchField;
import de.markusbordihn.easynpc.client.screen.components.SkinSelectionButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.configuration.skin.SkinConfigurationScreen;
import de.markusbordihn.easynpc.client.texture.CustomTextureManager;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinData;
import de.markusbordihn.easynpc.io.CustomSkinDataFiles;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.screen.ScreenHelper;
import de.markusbordihn.easynpc.utils.TextUtils;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class CustomSkinConfigurationScreen<T extends ConfigurationMenu>
extends SkinConfigurationScreen<T> {
    private static final float SKIN_NAME_SCALING = 0.7f;
    private static final int ADD_SKIN_RELOAD_DELAY = 5;
    protected Button skinFolderButton = null;
    protected Button skinReloadButton = null;
    protected EditBox skinSearchField = null;
    private String searchFilter = null;

    public CustomSkinConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    private void renderSkins(GuiGraphics guiGraphics) {
        if (this.getEasyNPC() == null) {
            return;
        }
        int positionTop = 144;
        int skinPosition = 0;
        this.skinButtons = new ArrayList();
        SkinData<?> skinData = this.getEasyNPC().getEasyNPCSkinData();
        SkinModel skinModel = skinData.getSkinModel();
        Set<UUID> textures = CustomTextureManager.getCustomTextureCacheKeys(skinModel, this.searchFilter);
        this.numOfSkins = textures.size();
        Object[] textureKeys = textures.toArray();
        if (this.lastNumOfSkins != this.numOfSkins) {
            this.checkSkinNavigationButtonState();
            this.lastNumOfSkins = this.numOfSkins;
        }
        for (int i = this.skinStartIndex; i < this.numOfSkins && i < this.skinStartIndex + this.maxSkinsPerPage; ++i) {
            int left = this.leftPos + 32 + skinPosition * 60;
            int top = this.topPos + 65 + positionTop;
            UUID textureKey = (UUID)textureKeys[i];
            this.renderSkinEntity(guiGraphics, left, top, textureKey);
            int topNamePos = Math.round(((float)top - 76.0f) / 0.7f);
            int leftNamePos = Math.round(((float)left - 21.0f) / 0.7f);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
            guiGraphics.pose().scale(0.7f, 0.7f, 0.7f);
            String variantName = TextUtils.normalizeString(textureKey.toString(), 11);
            Text.drawString(guiGraphics, this.font, variantName, leftNamePos, topNamePos, 43520);
            guiGraphics.pose().popPose();
            ++skinPosition;
        }
    }

    private void renderSkinEntity(GuiGraphics guiGraphics, int x, int y, UUID textureUUID) {
        SkinSelectionButton skinButton = new SkinSelectionButton(x - 24, y - 81, button -> NetworkMessageHandlerManager.getServerHandler().setCustomSkin(this.getEasyNPCUUID(), textureUUID));
        SkinData<?> skinData = this.getEasyNPC().getEasyNPCSkinData();
        UUID skinUUID = skinData.getSkinUUID();
        skinButton.active = !skinUUID.equals(textureUUID);
        ScreenHelper.renderEntityCustomSkin(guiGraphics, x + 4, y, (float)x - this.xMouse, (float)(y - 40) - this.yMouse, this.getEasyNPC(), textureUUID, SkinType.CUSTOM);
        this.skinButtons.add(skinButton);
    }

    @Override
    public void init() {
        super.init();
        this.customSkinButton.active = false;
        this.setDescriptionText("custom_skin.text");
        SkinData<?> skinData = this.getEasyNPC().getEasyNPCSkinData();
        SkinModel skinModel = skinData.getSkinModel();
        this.numOfSkins = CustomTextureManager.getCustomTextureCacheKeys(skinModel).size();
        this.defineSkinNavigationButtons();
        Path skinModelFolder = CustomSkinDataFiles.getCustomSkinDataFolder(skinModel);
        if (skinModelFolder != null) {
            this.skinFolderButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.contentLeftPos + 10, this.contentTopPos + 65, 263, "open_textures_folder", skinModel.toString(), onPress -> Util.getPlatform().openFile(skinModelFolder.toFile())));
        }
        this.skinReloadButton = (Button)this.addRenderableWidget((GuiEventListener)new ReloadButton(this.skinFolderButton.getX() + this.skinFolderButton.getWidth(), this.skinFolderButton.getY(), 17, 16, null, onPress -> {
            CustomSkinDataFiles.refreshRegisterTextureFiles();
            nextSkinReload = (int)Instant.now().getEpochSecond() + 5;
        }));
        this.skinSearchField = (EditBox)this.addRenderableWidget((GuiEventListener)new SearchField(this.font, this.contentLeftPos + 100, this.contentTopPos + 190, 100, 14));
        this.skinSearchField.setResponder(this::onSearchFieldChanged);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.render(guiGraphics, x, y, partialTicks);
        this.renderDescriptionText(guiGraphics, this.contentLeftPos + 5, this.contentTopPos + 5);
        if (this.skinReloadButton != null) {
            boolean canSkinReload;
            boolean bl = canSkinReload = Instant.now().getEpochSecond() >= (long)nextSkinReload;
            if (!canSkinReload) {
                Text.drawConfigString(guiGraphics, this.font, "skin_reloading", this.contentLeftPos + 55, this.contentTopPos + 93, 0xFF5555);
            }
            this.skinReloadButton.active = canSkinReload;
        }
        this.renderSkins(guiGraphics);
    }

    private void onSearchFieldChanged(String searchText) {
        if (searchText != null && !searchText.isEmpty()) {
            this.searchFilter = searchText;
            this.skinStartIndex = 0;
            this.checkSkinNavigationButtonState();
        } else {
            this.searchFilter = "";
        }
    }
}

