/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.data.skin.SkinDataEntry;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import java.util.EnumMap;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;

public interface SkinData<T extends PathfinderMob>
extends EasyNPC<T> {
    public static final String EASY_NPC_DATA_SKIN_DATA_TAG = "SkinData";
    public static final String EASY_NPC_DATA_SKIN_NAME_TAG = "SkinName";
    public static final String EASY_NPC_DATA_SKIN_TYPE_TAG = "SkinType";
    public static final String EASY_NPC_DATA_SKIN_URL_TAG = "SkinURL";
    public static final String EASY_NPC_DATA_SKIN_UUID_TAG = "SkinUUID";

    public static void registerSyncedSkinData(EnumMap<SynchedDataIndex, EntityDataAccessor<?>> map, Class<? extends Entity> entityClass) {
        log.info("- Registering Synched Skin Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.SKIN_DATA, SynchedEntityData.defineId(entityClass, EntityDataSerializersManager.SKIN_DATA_ENTRY));
    }

    default public int getEntitySkinScaling() {
        return 30;
    }

    default public String getSkinName() {
        return this.getSkinDataEntry().name();
    }

    default public String getSkinURL() {
        return this.getSkinDataEntry().url();
    }

    default public UUID getSkinUUID() {
        return this.getSkinDataEntry().uuid();
    }

    default public SkinType getSkinType() {
        return this.getSkinDataEntry().type();
    }

    default public SkinType getSkinType(String name) {
        return SkinType.get(name);
    }

    default public SkinModel getSkinModel() {
        return SkinModel.HUMANOID;
    }

    default public SkinDataEntry getSkinDataEntry() {
        return (SkinDataEntry)this.getSynchedEntityData(SynchedDataIndex.SKIN_DATA);
    }

    default public void setSkinDataEntry(SkinDataEntry skinDataEntry) {
        this.setSynchedEntityData(SynchedDataIndex.SKIN_DATA, skinDataEntry);
    }

    default public void defineSynchedSkinData(SynchedEntityData.Builder builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.SKIN_DATA, new SkinDataEntry());
    }

    default public void addAdditionalSkinData(CompoundTag compoundTag) {
        CompoundTag skinTag = new CompoundTag();
        this.getSkinDataEntry().write(skinTag);
        compoundTag.put(EASY_NPC_DATA_SKIN_DATA_TAG, (Tag)skinTag);
    }

    default public void readAdditionalSkinData(CompoundTag compoundTag) {
        if (!compoundTag.contains(EASY_NPC_DATA_SKIN_DATA_TAG)) {
            log.warn("No skin data available for {}.", (Object)this);
            return;
        }
        CompoundTag skinTag = compoundTag.getCompound(EASY_NPC_DATA_SKIN_DATA_TAG);
        if (skinTag.contains(EASY_NPC_DATA_SKIN_TYPE_TAG)) {
            log.info("Converting old skin data {} to new format ...", (Object)skinTag);
            SkinDataEntry skinDataEntry = new SkinDataEntry(skinTag.getString(EASY_NPC_DATA_SKIN_NAME_TAG), skinTag.getString(EASY_NPC_DATA_SKIN_URL_TAG), skinTag.contains(EASY_NPC_DATA_SKIN_UUID_TAG) ? skinTag.getUUID(EASY_NPC_DATA_SKIN_UUID_TAG) : Constants.BLANK_UUID, SkinType.get(skinTag.getString(EASY_NPC_DATA_SKIN_TYPE_TAG)));
            this.setSkinDataEntry(skinDataEntry);
            return;
        }
        SkinDataEntry skinDataEntry = new SkinDataEntry(skinTag);
        this.setSkinDataEntry(skinDataEntry);
    }
}

