/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.item.configuration;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EasyNPCPresetItem
extends Item {
    public static final String ENTITY_TYPE_TAG = "EntityType";
    public static final String NAME = "easy_npc_preset";
    public static final String PRESET_TAG = "Preset";
    public static final String SPAWNER_UUID_TAG = "SpawnerUUID";
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    private static final String FALL_DISTANCE_TAG = "FallDistance";
    private static final String FIRE_TAG = "Fire";
    private static final String MOTION_TAG = "Motion";
    private static final String ON_GROUND_TAG = "OnGround";
    private static final String CUSTOM_NAME_TAG = "CustomName";
    private static final String TEXT_TAG = "text";

    public EasyNPCPresetItem(Item.Properties properties) {
        super(properties);
    }

    public static boolean hasPreset(ItemStack itemStack) {
        CustomData customData = (CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        return customData != null && customData.contains(PRESET_TAG) && !customData.getUnsafe().getCompound(PRESET_TAG).isEmpty();
    }

    public static CompoundTag getPreset(ItemStack itemStack) {
        CustomData customData = (CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        return customData.contains(PRESET_TAG) ? customData.getUnsafe().getCompound(PRESET_TAG) : new CompoundTag();
    }

    public static void savePreset(ItemStack itemStack, ResourceLocation entityType, CompoundTag presetData) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putString(ENTITY_TYPE_TAG, entityType.toString());
        compoundTag.put(PRESET_TAG, (Tag)presetData);
        if (compoundTag.contains(FIRE_TAG)) {
            compoundTag.remove(FIRE_TAG);
        }
        if (compoundTag.contains(FALL_DISTANCE_TAG)) {
            compoundTag.remove(FALL_DISTANCE_TAG);
        }
        if (compoundTag.contains(MOTION_TAG)) {
            compoundTag.remove(MOTION_TAG);
        }
        if (compoundTag.contains(ON_GROUND_TAG)) {
            compoundTag.remove(ON_GROUND_TAG);
        }
        CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)itemStack, (CompoundTag)compoundTag);
    }

    public static String getCustomName(ItemStack itemStack) {
        CompoundTag customNameTag;
        CompoundTag compoundTag = EasyNPCPresetItem.getPreset(itemStack);
        if (compoundTag.contains(CUSTOM_NAME_TAG) && (customNameTag = compoundTag.getCompound(CUSTOM_NAME_TAG)).contains(TEXT_TAG)) {
            return customNameTag.getString(TEXT_TAG);
        }
        return null;
    }

    public static boolean hasEntityType(ItemStack itemStack) {
        CustomData customData = (CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        return customData.contains(ENTITY_TYPE_TAG) && !customData.getUnsafe().getString(ENTITY_TYPE_TAG).isEmpty();
    }

    public static EntityType<?> getEntityType(ItemStack itemStack) {
        CustomData customData = (CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        if (customData.contains(ENTITY_TYPE_TAG)) {
            return EntityType.byString((String)customData.getUnsafe().getString(ENTITY_TYPE_TAG)).orElse(null);
        }
        return null;
    }

    public static void setSpawnerUUID(ItemStack itemStack, UUID uuid) {
        CustomData customData = (CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag compoundTag = customData.getUnsafe();
        if (uuid != null) {
            compoundTag.putUUID(SPAWNER_UUID_TAG, uuid);
        } else {
            compoundTag.remove(SPAWNER_UUID_TAG);
        }
        CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)itemStack, (CompoundTag)compoundTag);
    }

    public static UUID getSpawnerUUID(ItemStack itemStack) {
        CustomData customData = (CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        return customData.contains(SPAWNER_UUID_TAG) ? customData.getUnsafe().getUUID(SPAWNER_UUID_TAG) : null;
    }

    public static boolean spawnAtPosition(BlockPos blockPos, ItemStack itemStack, Level level) {
        if (level.isClientSide || !EasyNPCPresetItem.hasPreset(itemStack) || !EasyNPCPresetItem.hasEntityType(itemStack)) {
            return false;
        }
        CompoundTag entityPreset = EasyNPCPresetItem.getPreset(itemStack);
        EntityType<?> entityType = EasyNPCPresetItem.getEntityType(itemStack);
        if (entityType == null) {
            log.error("No valid entity type found in {}!", (Object)itemStack);
            return false;
        }
        Entity entity = entityType.create(level);
        if (entity == null) {
            log.error("Unable to create entity for {} in {}", entityType, (Object)level);
            return false;
        }
        if (entityPreset.contains("UUID")) {
            entityPreset.remove("UUID");
        }
        entity.load(entityPreset);
        UUID spawnerUUID = EasyNPCPresetItem.getSpawnerUUID(itemStack);
        if (spawnerUUID != null && entity instanceof EasyNPC) {
            EasyNPC easyNPC = (EasyNPC)entity;
            easyNPC.getEasyNPCSpawnerData().setSpawnerUUID(EasyNPCPresetItem.getSpawnerUUID(itemStack));
        }
        entity.moveTo((double)((float)blockPos.getX() + 0.5f), (double)blockPos.getY(), (double)((float)blockPos.getZ() + 0.5f));
        if (level.addFreshEntity(entity)) {
            log.debug("Spawned {} at {} from spawner {} with {} in {}", entityType, (Object)blockPos, (Object)spawnerUUID, (Object)entityPreset, (Object)level);
            return true;
        }
        return false;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemStack = context.getItemInHand();
        if (itemStack.isEmpty() || !EasyNPCPresetItem.hasPreset(itemStack) || !EasyNPCPresetItem.hasEntityType(itemStack)) {
            log.warn("No valid preset found in {}!", (Object)itemStack);
            return InteractionResult.FAIL;
        }
        Iterable possibleSpawnPositions = BlockPos.spiralAround((BlockPos)context.getClickedPos(), (int)4, (Direction)Direction.NORTH, (Direction)Direction.EAST);
        for (BlockPos.MutableBlockPos blockPos : possibleSpawnPositions) {
            AABB aabb = new AABB((BlockPos)blockPos).inflate(0.1);
            BlockPos targetBlockPos = new BlockPos(blockPos.getX(), blockPos.getY(), blockPos.getZ());
            if (!level.getBlockState(targetBlockPos.above()).isAir() || !level.getEntitiesOfClass(Entity.class, aabb).isEmpty() || !EasyNPCPresetItem.spawnAtPosition(targetBlockPos, itemStack, level)) continue;
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean canAttackBlock(BlockState blockState, Level level, BlockPos blockPos, Player player) {
        return false;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltipList, TooltipFlag tooltipFlag) {
        EntityType<?> entityType;
        if (EasyNPCPresetItem.hasPreset(itemStack) && (entityType = EasyNPCPresetItem.getEntityType(itemStack)) != null) {
            tooltipList.add((Component)TextComponent.getTranslatedTextRaw("text.easy_npc.item.easy_npc_preset"));
            String customName = EasyNPCPresetItem.getCustomName(itemStack);
            if (customName != null) {
                tooltipList.add((Component)TextComponent.getTranslatedTextRaw("text.easy_npc.item.easy_npc_preset.custom_name", customName));
            }
            tooltipList.add((Component)TextComponent.getTranslatedTextRaw("text.easy_npc.item.easy_npc_preset.entity_type", entityType.getDescription()));
        }
    }
}

