/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.SkinHandler;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import de.markusbordihn.easynpc.utils.PlayersUtils;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record ChangeSkinMessage(UUID uuid, String skinName, String skinURL, UUID skinUUID, SkinType skinType, String skinVariant) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"change_skin");
    public static final CustomPacketPayload.Type<ChangeSkinMessage> PAYLOAD_TYPE = new CustomPacketPayload.Type(MESSAGE_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, ChangeSkinMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> message.write((FriendlyByteBuf)buffer), ChangeSkinMessage::create);

    public static ChangeSkinMessage create(FriendlyByteBuf buffer) {
        return new ChangeSkinMessage(buffer.readUUID(), buffer.readUtf(), buffer.readUtf(), buffer.readUUID(), (SkinType)buffer.readEnum(SkinType.class), buffer.readUtf());
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.uuid);
        buffer.writeUtf(this.skinName);
        buffer.writeUtf(this.skinURL);
        buffer.writeUUID(this.skinUUID);
        buffer.writeEnum((Enum)this.skinType);
        buffer.writeUtf(this.skinVariant);
    }

    @Override
    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PAYLOAD_TYPE;
    }

    @Override
    public void handleServer(ServerPlayer serverPlayer) {
        boolean successfullyChanged;
        EasyNPC<?> easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null || this.skinName == null || this.skinType == null || easyNPC.getEasyNPCSkinData() == null) {
            log.error("Skin validation failed for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        switch (this.skinType) {
            case NONE: {
                boolean bl = SkinHandler.setNoneSkin(easyNPC);
                break;
            }
            case CUSTOM: {
                boolean bl = SkinHandler.setCustomSkin(easyNPC, this.skinUUID);
                break;
            }
            case DEFAULT: {
                boolean bl = SkinHandler.setDefaultSkin(easyNPC, this.skinVariant);
                break;
            }
            case PLAYER_SKIN: {
                UUID userUUID = this.skinUUID;
                if (userUUID == null || Constants.BLANK_UUID.equals(this.skinUUID)) {
                    log.debug("Try to convert user {} to UUID ...", (Object)this.skinName);
                    userUUID = PlayersUtils.getUserUUID(serverPlayer.getServer(), this.skinName);
                }
                boolean bl = SkinHandler.setPlayerSkin(easyNPC, this.skinName, userUUID);
                break;
            }
            case SECURE_REMOTE_URL: 
            case INSECURE_REMOTE_URL: {
                boolean bl = SkinHandler.setRemoteSkin(easyNPC, this.skinURL);
                break;
            }
            default: {
                log.error("Failed processing skin:{} uuid:{} url:{} type:{} for {} from {}", (Object)this.skinName, (Object)this.skinUUID, (Object)this.skinURL, (Object)this.skinType, easyNPC, (Object)serverPlayer);
                boolean bl = successfullyChanged = false;
            }
        }
        if (!successfullyChanged) {
            log.error("Failed changing skin:{} uuid:{} url:{} type:{} for {} from {}", (Object)this.skinName, (Object)this.skinUUID, (Object)this.skinURL, (Object)this.skinType, easyNPC, (Object)serverPlayer);
        }
    }
}

