/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.PresetData;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinData;
import de.markusbordihn.easynpc.io.WorldPresetDataFiles;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record ExportWorldPresetMessage(UUID uuid, String name) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"export_world_preset");
    public static final CustomPacketPayload.Type<ExportWorldPresetMessage> PAYLOAD_TYPE = new CustomPacketPayload.Type(MESSAGE_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, ExportWorldPresetMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> message.write((FriendlyByteBuf)buffer), ExportWorldPresetMessage::create);

    public static ExportWorldPresetMessage create(FriendlyByteBuf buffer) {
        return new ExportWorldPresetMessage(buffer.readUUID(), buffer.readUtf());
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.uuid);
        buffer.writeUtf(this.name);
    }

    @Override
    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PAYLOAD_TYPE;
    }

    @Override
    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC<?> easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.name == null || this.name.isEmpty()) {
            log.warn("Export preset name is empty for {}", easyNPC);
            return;
        }
        SkinData<?> skinData = easyNPC.getEasyNPCSkinData();
        if (skinData == null) {
            log.warn("Export preset skin data is empty for {}", easyNPC);
            return;
        }
        SkinModel skinModel = skinData.getSkinModel();
        if (skinModel == null) {
            log.warn("Export preset skin model is empty for {}", easyNPC);
            return;
        }
        PresetData<?> presetData = easyNPC.getEasyNPCPresetData();
        CompoundTag compoundTag = presetData.exportPresetData();
        if (compoundTag == null || compoundTag.isEmpty()) {
            log.warn("Export preset data is empty for {}", easyNPC);
            return;
        }
        File presetFile = WorldPresetDataFiles.getPresetFile(skinModel, this.name);
        if (presetFile == null) {
            log.error("Failed to get preset file for {} with name {}", (Object)skinModel, (Object)this.name);
            return;
        }
        log.info("Exporting EasyNPC {} with {} and skin {} to {}", (Object)this.name, easyNPC, (Object)skinModel, (Object)presetFile);
        try {
            NbtIo.writeCompressed((CompoundTag)compoundTag, (Path)presetFile.toPath());
        }
        catch (IOException exception) {
            log.error("Failed to export EasyNPC {} with {} and skin {} to {}:", (Object)this.name, easyNPC, (Object)skinModel, (Object)presetFile, (Object)exception);
        }
    }
}

