/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.additionallanterns.mixin;

import com.supermartijn642.additionallanterns.WeatheringLanternBlock;
import java.util.Optional;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WeatheringCopper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WeatheringCopper.class})
public interface WeatheringCopperMixin {
    @Inject(method={"getPrevious(Lnet/minecraft/world/level/block/Block;)Ljava/util/Optional;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getPrevious(Block block, CallbackInfoReturnable<Optional<Block>> ci) {
        Block previous;
        if (WeatheringLanternBlock.WEATHERING_MAP != null && (previous = (Block)WeatheringLanternBlock.WEATHERING_MAP.inverse().get((Object)block)) != null) {
            ci.setReturnValue(Optional.of(previous));
        }
    }

    @Inject(method={"getFirst(Lnet/minecraft/world/level/block/Block;)Lnet/minecraft/world/level/block/Block;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getFirst(Block block, CallbackInfoReturnable<Block> ci) {
        if (WeatheringLanternBlock.WEATHERING_MAP != null) {
            Block previous;
            Block first = block;
            while ((previous = (Block)WeatheringLanternBlock.WEATHERING_MAP.inverse().get((Object)first)) != null) {
                first = previous;
            }
            if (first != block) {
                ci.setReturnValue((Object)first);
            }
        }
    }

    @Inject(method={"getNext(Lnet/minecraft/world/level/block/Block;)Ljava/util/Optional;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getNext(Block block, CallbackInfoReturnable<Optional<Block>> ci) {
        Block next;
        if (WeatheringLanternBlock.WEATHERING_MAP != null && (next = (Block)WeatheringLanternBlock.WEATHERING_MAP.get((Object)block)) != null) {
            ci.setReturnValue(Optional.of(next));
        }
    }
}

