/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.BlockColoredLamp;
import de.ellpeck.actuallyadditions.mod.blocks.base.FullyDirectionalBlock;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockLampController
extends FullyDirectionalBlock {
    public BlockLampController() {
        super(ActuallyBlocks.defaultPickProps());
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        this.updateLamp(worldIn, pos);
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.updateLamp(world, pos);
    }

    private void updateLamp(Level world, BlockPos pos) {
        if (!world.isClientSide) {
            BlockState state = world.getBlockState(pos);
            BlockPos coords = pos.relative(WorldUtil.getDirectionByPistonRotation(state));
            this.updateLampsAtPos(world, coords, world.getBestNeighborSignal(pos) > 0, new ArrayList<BlockPos>());
        }
    }

    private void updateLampsAtPos(Level world, BlockPos pos, boolean powered, List<BlockPos> updatedAlready) {
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof BlockColoredLamp) {
            if (((Boolean)state.getValue((Property)BlockStateProperties.LIT)).booleanValue() && !powered) {
                world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false)));
            }
            if (!((Boolean)state.getValue((Property)BlockStateProperties.LIT)).booleanValue() && powered) {
                world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)));
            }
            this.updateSurrounding(world, pos, powered, updatedAlready);
        }
    }

    private void updateSurrounding(Level world, BlockPos pos, boolean powered, List<BlockPos> updatedAlready) {
        for (Direction side : Direction.values()) {
            BlockPos offset = pos.relative(side);
            if (updatedAlready.contains(offset)) continue;
            updatedAlready.add(pos);
            this.updateLampsAtPos(world, offset, powered, updatedAlready);
        }
    }
}

