/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class CoffeeIngredientRecipe
implements Recipe<RecipeInput> {
    public static final String NAME = "coffee_ingredient";
    protected final Ingredient ingredient;
    protected final NonNullList<EffectInstance> instances;
    protected final List<MobEffectInstance> effects;
    protected final int maxAmplifier;
    protected final String extraText;

    public CoffeeIngredientRecipe(Ingredient ingredient, NonNullList<EffectInstance> effectInstances, int maxAmplifier, String extraText) {
        EffectInstance instance;
        Holder effect;
        this.ingredient = ingredient;
        this.maxAmplifier = maxAmplifier;
        this.instances = effectInstances;
        ArrayList<MobEffectInstance> instances = new ArrayList<MobEffectInstance>();
        Iterator iterator = effectInstances.iterator();
        while (iterator.hasNext() && (effect = (Holder)BuiltInRegistries.MOB_EFFECT.getHolder((instance = (EffectInstance)iterator.next()).effect()).orElse(null)) != null) {
            instances.add(new MobEffectInstance(effect, instance.duration, instance.amplifier));
        }
        this.effects = instances;
        this.extraText = extraText;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public List<MobEffectInstance> getEffects() {
        return this.effects;
    }

    public int getMaxAmplifier() {
        return this.maxAmplifier;
    }

    public String getExtraText() {
        return this.extraText;
    }

    public boolean matches(RecipeInput container, Level level) {
        return false;
    }

    public boolean matches(ItemStack itemStack) {
        return this.ingredient.test(itemStack);
    }

    public ItemStack assemble(RecipeInput container, HolderLookup.Provider registries) {
        return this.getResultItem(registries);
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return ActuallyRecipes.COFFEE_INGREDIENT_RECIPE.get();
    }

    public RecipeType<?> getType() {
        return ActuallyRecipes.Types.COFFEE_INGREDIENT.get();
    }

    public boolean effect(ItemStack stack) {
        return ActuallyAdditionsAPI.methodHandler.addRecipeEffectToStack(stack, this);
    }

    public static Optional<RecipeHolder<CoffeeIngredientRecipe>> getIngredientForStack(ItemStack ingredient) {
        return ActuallyAdditionsAPI.COFFEE_MACHINE_INGREDIENTS.stream().filter(recipe -> ((CoffeeIngredientRecipe)recipe.value()).matches(ingredient)).findFirst();
    }

    public record EffectInstance(ResourceLocation effect, int duration, int amplifier) {
        public static final EffectInstance EMPTY = new EffectInstance(ResourceLocation.tryParse((String)"darkness"), 0, 0);
        public static final Codec<EffectInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("effect").forGetter(effect -> effect.effect), (App)Codec.INT.fieldOf("duration").forGetter(effect -> effect.duration), (App)Codec.INT.fieldOf("amplifier").forGetter(effect -> effect.amplifier)).apply((Applicative)instance, EffectInstance::new));

        public EffectInstance(MobEffectInstance effect) {
            this(BuiltInRegistries.MOB_EFFECT.getKey((Object)((MobEffect)effect.getEffect().value())), effect.getDuration(), effect.getAmplifier());
        }

        public static EffectInstance fromNetwork(FriendlyByteBuf pBuffer) {
            ResourceLocation effect = pBuffer.readResourceLocation();
            int duration = pBuffer.readVarInt();
            int amplifier = pBuffer.readVarInt();
            return new EffectInstance(effect, duration, amplifier);
        }

        public void toNetwork(FriendlyByteBuf pBuffer) {
            pBuffer.writeResourceLocation(this.effect);
            pBuffer.writeVarInt(this.duration);
            pBuffer.writeVarInt(this.amplifier);
        }
    }

    public static class Serializer
    implements RecipeSerializer<CoffeeIngredientRecipe> {
        private static final MapCodec<CoffeeIngredientRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)EffectInstance.CODEC.listOf().optionalFieldOf("effects", new ArrayList()).flatXmap(list -> {
            for (EffectInstance effect : list) {
                if (BuiltInRegistries.MOB_EFFECT.containsKey(effect.effect)) continue;
                return DataResult.error(() -> "Unknown effect: %s".formatted(effect.effect));
            }
            return DataResult.success((Object)NonNullList.of((Object)EffectInstance.EMPTY, (Object[])((EffectInstance[])list.toArray(EffectInstance[]::new))));
        }, DataResult::success).forGetter(recipe -> recipe.instances), (App)Codec.INT.fieldOf("max_amplifier").forGetter(recipe -> recipe.maxAmplifier), (App)Codec.STRING.optionalFieldOf("extra_text", (Object)"").forGetter(recipe -> recipe.extraText)).apply((Applicative)instance, CoffeeIngredientRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CoffeeIngredientRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<CoffeeIngredientRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CoffeeIngredientRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static CoffeeIngredientRecipe fromNetwork(@Nonnull RegistryFriendlyByteBuf pBuffer) {
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)pBuffer);
            int i = pBuffer.readVarInt();
            NonNullList list = NonNullList.withSize((int)i, (Object)EffectInstance.EMPTY);
            for (int j = 0; j < list.size(); ++j) {
                list.set(j, (Object)EffectInstance.fromNetwork((FriendlyByteBuf)pBuffer));
            }
            int maxAmplifier = pBuffer.readInt();
            String extraText = pBuffer.readUtf(Short.MAX_VALUE);
            return new CoffeeIngredientRecipe(ingredient, (NonNullList<EffectInstance>)list, maxAmplifier, extraText);
        }

        public static void toNetwork(@Nonnull RegistryFriendlyByteBuf pBuffer, CoffeeIngredientRecipe pRecipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.ingredient);
            pBuffer.writeVarInt(pRecipe.instances.size());
            for (EffectInstance effect : pRecipe.instances) {
                effect.toNetwork((FriendlyByteBuf)pBuffer);
            }
            pBuffer.writeInt(pRecipe.maxAmplifier);
            pBuffer.writeUtf(pRecipe.extraText);
        }
    }
}

