/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.inventory.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerLaserRelayItemWhitelist;
import de.ellpeck.actuallyadditions.mod.inventory.gui.AAScreen;
import de.ellpeck.actuallyadditions.mod.inventory.gui.FilterSettingsGui;
import de.ellpeck.actuallyadditions.mod.network.PacketHelperClient;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayItemAdvanced;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;

public class GuiLaserRelayItemWhitelist
extends AAScreen<ContainerLaserRelayItemWhitelist> {
    private static final ResourceLocation RES_LOC = AssetUtil.getGuiLocation("gui_laser_relay_item_whitelist");
    private final Component inboundText = Component.translatable((String)"info.actuallyadditions.gui.inbound");
    private final Component outboundText = Component.translatable((String)"info.actuallyadditions.gui.outbound");
    private final TileEntityLaserRelayItemAdvanced tile;
    private FilterSettingsGui leftFilter;
    private FilterSettingsGui rightFilter;
    private Button buttonSmartWhitelistLeft;
    private Button buttonSmartWhitelistRight;

    public GuiLaserRelayItemWhitelist(ContainerLaserRelayItemWhitelist container, Inventory inventory, Component title) {
        super(container, inventory, title);
        this.tile = container.tile;
        this.imageWidth = 176;
        this.imageHeight = 179;
    }

    public void containerTick() {
        super.containerTick();
        this.leftFilter.tick();
        this.rightFilter.tick();
    }

    @Override
    public void init() {
        super.init();
        this.leftFilter = new FilterSettingsGui(this.tile.leftFilter, this.leftPos + 3, this.topPos + 6, true, x$0 -> {
            AbstractButton cfr_ignored_0 = (AbstractButton)this.addRenderableWidget((GuiEventListener)x$0);
        }, id -> PacketHelperClient.sendButtonPacket(this.tile, id), 0);
        this.rightFilter = new FilterSettingsGui(this.tile.rightFilter, this.leftPos + 157, this.topPos + 6, true, x$0 -> {
            AbstractButton cfr_ignored_0 = (AbstractButton)this.addRenderableWidget((GuiEventListener)x$0);
        }, id -> PacketHelperClient.sendButtonPacket(this.tile, id), 4);
        this.buttonSmartWhitelistLeft = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"S"), button -> PacketHelperClient.sendButtonPacket(this.tile, 8)).bounds(this.leftPos + 3, this.topPos + 79, 16, 16).build());
        this.buttonSmartWhitelistRight = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"S"), button -> PacketHelperClient.sendButtonPacket(this.tile, 9)).bounds(this.leftPos + 157, this.topPos + 79, 16, 16).build());
    }

    @Override
    public void render(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.leftFilter.drawHover(guiGraphics, mouseX, mouseY);
        this.rightFilter.drawHover(guiGraphics, mouseX, mouseY);
        if (this.buttonSmartWhitelistLeft.isMouseOver((double)mouseX, (double)mouseY) || this.buttonSmartWhitelistRight.isMouseOver((double)mouseX, (double)mouseY)) {
            ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
            list.add(Component.translatable((String)"info.actuallyadditions.gui.smart").withStyle(ChatFormatting.BOLD).getVisualOrderText());
            list.addAll(this.font.split((FormattedText)Component.translatable((String)"info.actuallyadditions.gui.smartInfo"), 200));
            guiGraphics.renderTooltip(this.font, list, mouseX, mouseY);
        }
    }

    @Override
    public void renderLabels(@Nonnull GuiGraphics guiGraphics, int x, int y) {
        AssetUtil.displayNameString(guiGraphics, this.font, this.imageWidth, -10, this.title.getString());
        guiGraphics.drawString(this.font, this.inboundText, 46 - this.font.width((FormattedText)this.inboundText) / 2, 80, 0x404040, false);
        guiGraphics.drawString(this.font, this.outboundText, 131 - this.font.width((FormattedText)this.outboundText) / 2, 80, 0x404040, false);
    }

    public void renderBg(GuiGraphics guiGraphics, float f, int x, int y) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(AssetUtil.GUI_INVENTORY_LOCATION, this.leftPos, this.topPos + 93, 0, 0, 176, 86);
        guiGraphics.blit(RES_LOC, this.leftPos, this.topPos, 0, 0, 176, 93);
    }
}

